/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.document;

import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.ui.web.component.VariableManager;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;

public class RestDocumentLink
extends HtmlOutputLink {
    public static final String COMPONENT_TYPE = RestDocumentLink.class.getName();
    public static final String COMPONENT_FAMILY = RestDocumentLink.class.getName();
    public static final String DEFAULT_VIEW_ID = "view_documents";
    protected static final HtmlBasicRenderer.Param[] EMPTY_PARAMS = new HtmlBasicRenderer.Param[0];
    protected DocumentModel document;
    protected String repositoryName;
    protected DocumentRef documentIdRef;
    protected String view;
    protected String tab;
    protected String subTab;
    protected String tabs;
    protected Boolean addTabInfo;
    protected String pattern;
    protected Boolean newConversation;
    protected String baseURL;
    protected String var;
    protected Boolean resolveOnly;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Object getValue() {
        HtmlBasicRenderer.Param[] paramTags;
        DocumentModel doc = this.getDocument();
        String repoName = this.getRepositoryName();
        if (doc == null && repoName == null) {
            return null;
        }
        String viewId = this.getView();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        String tabValue = this.getTab();
        String subTabValue = this.getSubTab();
        String tabValues = this.getTabs();
        if (tabValues == null) {
            tabValues = "";
        }
        if (tabValue != null && !tabValue.isEmpty()) {
            if (!tabValues.isEmpty()) {
                tabValues = tabValues + ",";
            }
            tabValues = tabValues + ":" + tabValue;
            if (subTabValue != null) {
                tabValues = tabValues + ":" + subTabValue;
            }
        } else if (Boolean.TRUE.equals(this.getAddTabInfo())) {
            if (!tabValues.isEmpty()) {
                tabValues = tabValues + ",";
            }
            tabValues = tabValues + ":";
        }
        if (!tabValues.isEmpty()) {
            params.put("tabIds", tabValues);
        }
        for (HtmlBasicRenderer.Param param : paramTags = this.getParamList()) {
            String pv;
            String pn = param.name;
            if (pn == null || pn.length() == 0 || (pv = param.value) == null || pv.length() == 0) continue;
            params.put(pn, pv);
        }
        String pattern = this.getPattern();
        String baseURL = this.getBaseURL();
        if (StringUtils.isEmpty((String)baseURL)) {
            baseURL = BaseURL.getBaseURL();
        }
        boolean useNewConversation = true;
        if (doc == null) {
            return DocumentModelFunctions.repositoryUrl(pattern, repoName, viewId, params, useNewConversation, baseURL);
        }
        return DocumentModelFunctions.documentUrl(pattern, doc, viewId, params, useNewConversation, baseURL);
    }

    protected HtmlBasicRenderer.Param[] getParamList() {
        if (this.getChildCount() > 0) {
            ArrayList<HtmlBasicRenderer.Param> parameterList = new ArrayList<HtmlBasicRenderer.Param>();
            for (UIComponent kid : this.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                UIParameter uiParam = (UIParameter)kid;
                Object value = uiParam.getValue();
                HtmlBasicRenderer.Param param = new HtmlBasicRenderer.Param(uiParam.getName(), value == null ? null : value.toString());
                parameterList.add(param);
            }
            return parameterList.toArray(new HtmlBasicRenderer.Param[parameterList.size()]);
        }
        return EMPTY_PARAMS;
    }

    public String getPattern() {
        if (this.pattern != null) {
            return this.pattern;
        }
        ValueExpression ve = this.getValueExpression("pattern");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setPattern(String codec) {
        this.pattern = codec;
    }

    public DocumentModel getDocument() {
        if (this.document != null) {
            return this.document;
        }
        ValueExpression ve = this.getValueExpression("document");
        if (ve != null) {
            try {
                return (DocumentModel)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setDocument(DocumentModel document) {
        this.document = document;
    }

    public String getRepositoryName() {
        if (this.repositoryName != null) {
            return this.repositoryName;
        }
        ValueExpression ve = this.getValueExpression("repositoryName");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public DocumentRef getDocumentIdRef() {
        if (this.documentIdRef != null) {
            return this.documentIdRef;
        }
        ValueExpression ve = this.getValueExpression("documentIdRef");
        if (ve != null) {
            try {
                String id = (String)ve.getValue(this.getFacesContext().getELContext());
                if (id != null) {
                    return new IdRef(id);
                }
                return null;
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setDocumentIdRef(DocumentRef documentIdRef) {
        this.documentIdRef = documentIdRef;
    }

    public Boolean getNewConversation() {
        if (this.newConversation != null) {
            return this.newConversation;
        }
        ValueExpression ve = this.getValueExpression("newConversation");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return Boolean.FALSE;
    }

    public void setNewConversation(Boolean newConversation) {
        this.newConversation = newConversation;
    }

    public String getSubTab() {
        if (this.subTab != null) {
            return this.subTab;
        }
        ValueExpression ve = this.getValueExpression("subTab");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setSubTab(String subTab) {
        this.subTab = subTab;
    }

    public String getTab() {
        if (this.tab != null) {
            return this.tab;
        }
        ValueExpression ve = this.getValueExpression("tab");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setTab(String tab) {
        this.tab = tab;
    }

    public String getBaseURL() {
        if (this.baseURL != null) {
            return this.baseURL;
        }
        ValueExpression ve = this.getValueExpression("baseURL");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getView() {
        if (this.view != null) {
            return this.view;
        }
        ValueExpression ve = this.getValueExpression("view");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setView(String view) {
        this.view = view;
    }

    public Boolean getAddTabInfo() {
        if (this.addTabInfo != null) {
            return this.addTabInfo;
        }
        ValueExpression ve = this.getValueExpression("addTabInfo");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return Boolean.TRUE;
    }

    public void setAddTabInfo(Boolean addTabInfo) {
        this.addTabInfo = addTabInfo;
    }

    public String getTabs() {
        if (this.tabs != null) {
            return this.tabs;
        }
        ValueExpression ve = this.getValueExpression("tabs");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setTabs(String tabs) {
        this.tabs = tabs;
    }

    public Boolean getResolveOnly() {
        if (this.resolveOnly != null) {
            return this.resolveOnly;
        }
        ValueExpression ve = this.getValueExpression("resolveOnly");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return Boolean.FALSE;
    }

    public void setResolveOnly(Boolean resolveOnly) {
        this.resolveOnly = resolveOnly;
    }

    public String getVar() {
        if (this.var != null) {
            return this.var;
        }
        ValueExpression ve = this.getValueExpression("var");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setVar(String var) {
        this.var = var;
    }

    protected Object beforeRender() {
        String var = this.getVar();
        Object orig = VariableManager.saveRequestMapVarValue(var);
        if (Boolean.TRUE.equals(this.getResolveOnly())) {
            VariableManager.putVariableToRequestParam(var, this.getValue());
        }
        return orig;
    }

    protected void afterRender(Object origVarValue) {
        String var = this.getVar();
        VariableManager.restoreRequestMapVarValue(var, origVarValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        Object varValue = this.beforeRender();
        try {
            boolean bl = super.invokeOnComponent(context, clientId, callback);
            return bl;
        }
        finally {
            this.afterRender(varValue);
        }
    }

    public void broadcast(FacesEvent event) {
        Object varValue = this.beforeRender();
        try {
            super.broadcast(event);
        }
        finally {
            this.afterRender(varValue);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!Boolean.TRUE.equals(this.getResolveOnly())) {
            super.encodeBegin(context);
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        Object varValue = this.beforeRender();
        try {
            super.encodeChildren(context);
        }
        finally {
            this.afterRender(varValue);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!Boolean.TRUE.equals(this.getResolveOnly())) {
            super.encodeEnd(context);
        }
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.document, this.documentIdRef, this.view, this.tab, this.subTab, this.tabs, this.addTabInfo, this.pattern, this.newConversation, this.baseURL, this.var, this.resolveOnly};
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.document = (DocumentModel)values[1];
        this.documentIdRef = (DocumentRef)values[2];
        this.view = (String)values[3];
        this.tab = (String)values[4];
        this.subTab = (String)values[5];
        this.tabs = (String)values[6];
        this.addTabInfo = (Boolean)values[7];
        this.pattern = (String)values[8];
        this.newConversation = (Boolean)values[9];
        this.baseURL = (String)values[10];
        this.var = (String)values[11];
        this.resolveOnly = (Boolean)values[12];
    }
}

