/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import jdbm.RecordManager;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertion;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertionEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexConfiguration;
import org.apache.directory.server.core.partition.impl.btree.IndexEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexNotFoundException;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmMasterTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmStoreConfiguration;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmStore {
    private static final Logger log = LoggerFactory.getLogger(JdbmStore.class);
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private RecordManager recMan;
    private LdapDN normSuffix;
    private LdapDN upSuffix;
    private File workingDirectory;
    private JdbmMasterTable master;
    private Map<String, Index> indices;
    private Map<String, Index> sysIndices;
    private boolean initialized;
    private boolean isSyncOnWrite = true;
    private Index ndnIdx;
    private Index updnIdx;
    private Index existanceIdx;
    private Index hierarchyIdx;
    private Index oneAliasIdx;
    private Index subAliasIdx;
    private Index aliasIdx;
    private static AttributeType OBJECT_CLASS_AT;
    private static AttributeType ALIASED_OBJECT_NAME_AT;
    private AttributeTypeRegistry attributeTypeRegistry;
    private OidRegistry oidRegistry;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initCustomIndex(Object index, Set<String> sysOidSet, Set<String> customAddedSystemIndices) throws NamingException {
        String name = null;
        int cacheSize = 100;
        int numDupLimit = 512;
        if (index instanceof String) {
            name = (String)index;
            if (log.isDebugEnabled()) {
                log.debug("Using default cache size of {} for index on attribute {}", (Object)new Integer(cacheSize), (Object)name);
            }
        } else if (index instanceof IndexConfiguration) {
            IndexConfiguration indexConfiguration = (IndexConfiguration)index;
            name = indexConfiguration.getAttributeId();
            cacheSize = indexConfiguration.getCacheSize();
            numDupLimit = indexConfiguration.getDuplicateLimit();
            if (cacheSize <= 0) {
                log.warn("Cache size {} for index on attribute is null or negative. Using default value.", (Object)new Integer(cacheSize), (Object)name);
                cacheSize = 100;
            } else {
                log.info("Using cache size of {} for index on attribute {}", (Object)new Integer(cacheSize), (Object)name);
            }
            if (cacheSize <= 0) {
                log.warn("Duplicate limit {} for index on attribute is null or negative. Using default value.", (Object)new Integer(numDupLimit), (Object)name);
                cacheSize = 100;
            } else {
                log.info("Using duplicate limit of {} for index on attribute {}", (Object)new Integer(numDupLimit), (Object)name);
            }
        }
        String oid = this.oidRegistry.getOid(name);
        AttributeType type = this.attributeTypeRegistry.lookup(oid);
        if (sysOidSet.contains(oid)) {
            if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.3")) {
                this.setExistanceIndexOn(type, cacheSize, numDupLimit);
                customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.3");
                return;
            } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.4")) {
                this.setHierarchyIndexOn(type, cacheSize, numDupLimit);
                customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.4");
                return;
            } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.2")) {
                this.setUpdnIndexOn(type, cacheSize, numDupLimit);
                customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.2");
                return;
            } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.1")) {
                this.setNdnIndexOn(type, cacheSize, numDupLimit);
                customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.1");
                return;
            } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.5")) {
                this.setOneAliasIndexOn(type, cacheSize, numDupLimit);
                customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.5");
                return;
            } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.6")) {
                this.setSubAliasIndexOn(type, cacheSize, numDupLimit);
                customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.6");
                return;
            } else {
                if (!oid.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) throw new NamingException("Unidentified system index " + oid);
                this.setAliasIndexOn(type, cacheSize, numDupLimit);
                customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.7");
            }
            return;
        } else {
            this.addIndexOn(type, cacheSize, numDupLimit);
        }
    }

    private void initSystemIndices(String systemIndexName, Set<String> customAddedSystemIndices) throws NamingException {
        if (!customAddedSystemIndices.contains(systemIndexName)) {
            AttributeType type = this.attributeTypeRegistry.lookup(systemIndexName);
            if (log.isDebugEnabled()) {
                log.debug("Using default cache size of {} for index on attribute {}", (Object)new Integer(100), (Object)systemIndexName);
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.3")) {
                this.setExistanceIndexOn(type, 100, 512);
            } else if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.4")) {
                this.setHierarchyIndexOn(type, 100, 512);
            } else if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.2")) {
                this.setUpdnIndexOn(type, 100, 512);
            } else if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.1")) {
                this.setNdnIndexOn(type, 100, 512);
            } else if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.5")) {
                this.setOneAliasIndexOn(type, 100, 512);
            } else if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.6")) {
                this.setSubAliasIndexOn(type, 100, 512);
            } else if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
                this.setAliasIndexOn(type, 100, 512);
            } else {
                throw new NamingException("Unidentified system index " + systemIndexName);
            }
        }
    }

    protected void initIndices2(Set indices) throws NamingException {
        HashSet<String> sysOidSet = new HashSet<String>();
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.3");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.4");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.2");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.1");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.5");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.6");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.7");
        HashSet<String> customAddedSystemIndices = new HashSet<String>();
        for (Object indexName : indices) {
            this.initCustomIndex(indexName, sysOidSet, customAddedSystemIndices);
        }
        for (String systemIndexName : sysOidSet) {
            this.initSystemIndices(systemIndexName, customAddedSystemIndices);
        }
    }

    protected void initSuffixEntry3(String suffix, Attributes entry) throws NamingException {
        Attributes suffixOnDisk = this.getSuffixEntry();
        if (suffixOnDisk == null) {
            LdapDN dn = new LdapDN(suffix);
            LdapDN normalizedSuffix = LdapDN.normalize((LdapDN)dn, (Map)this.attributeTypeRegistry.getNormalizerMapping());
            this.add(normalizedSuffix, entry);
        }
    }

    public synchronized void init(JdbmStoreConfiguration config) throws NamingException {
        this.isSyncOnWrite = config.isSyncOnWrite();
        this.oidRegistry = config.getOidRegistry();
        this.attributeTypeRegistry = config.getAttributeTypeRegistry();
        OBJECT_CLASS_AT = this.attributeTypeRegistry.lookup("objectClass");
        ALIASED_OBJECT_NAME_AT = this.attributeTypeRegistry.lookup("aliasedObjectName");
        this.upSuffix = new LdapDN(config.getSuffixDn());
        this.normSuffix = LdapDN.normalize((LdapDN)this.upSuffix, (Map)this.attributeTypeRegistry.getNormalizerMapping());
        this.workingDirectory = config.getWorkingDirectory();
        this.workingDirectory.mkdirs();
        try {
            String path = this.workingDirectory.getPath() + File.separator + "master";
            BaseRecordManager base = new BaseRecordManager(path);
            base.disableTransactions();
            int cacheSize = config.getCacheSize();
            if (cacheSize < 0) {
                cacheSize = 10000;
                if (log.isDebugEnabled()) {
                    log.debug("Using the default entry cache size of {} for {} partition", (Object)new Integer(cacheSize), (Object)config.getName());
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Using the custom configured cache size of {} for {} partition", (Object)new Integer(cacheSize), (Object)config.getName());
            }
            this.recMan = new CacheRecordManager((RecordManager)base, (CachePolicy)new MRU(cacheSize));
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Could not initialize RecordManager");
            ne.setRootCause(e);
            throw ne;
        }
        this.master = new JdbmMasterTable(this.recMan);
        this.indices = new HashMap<String, Index>();
        this.sysIndices = new HashMap<String, Index>();
        this.initIndices2(config.getIndexedAttributes());
        this.initSuffixEntry3(config.getSuffixDn(), config.getContextEntry());
        this.initialized = true;
    }

    public synchronized void destroy() {
        if (!this.initialized) {
            return;
        }
        ArrayList<Index> array = new ArrayList<Index>();
        array.addAll(this.indices.values());
        if (null != this.ndnIdx) {
            array.add(this.ndnIdx);
        }
        if (null != this.updnIdx) {
            array.add(this.updnIdx);
        }
        if (null != this.aliasIdx) {
            array.add(this.aliasIdx);
        }
        if (null != this.oneAliasIdx) {
            array.add(this.oneAliasIdx);
        }
        if (null != this.subAliasIdx) {
            array.add(this.subAliasIdx);
        }
        if (null != this.hierarchyIdx) {
            array.add(this.hierarchyIdx);
        }
        if (null != this.existanceIdx) {
            array.add(this.existanceIdx);
        }
        for (Index index : array) {
            try {
                index.close();
            }
            catch (Throwable t) {
                log.error("Failed to close an index.", t);
            }
        }
        try {
            this.master.close();
        }
        catch (Throwable t) {
            log.error("Failed to close the master.", t);
        }
        try {
            this.recMan.close();
        }
        catch (Throwable t) {
            log.error("Failed to close the record manager", t);
        }
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void sync() throws NamingException {
        if (!this.initialized) {
            return;
        }
        ArrayList<Index> array = new ArrayList<Index>();
        array.addAll(this.indices.values());
        array.add(this.ndnIdx);
        array.add(this.updnIdx);
        array.add(this.aliasIdx);
        array.add(this.oneAliasIdx);
        array.add(this.subAliasIdx);
        array.add(this.hierarchyIdx);
        array.add(this.existanceIdx);
        for (Index idx : array) {
            idx.sync();
        }
        this.master.sync();
        try {
            this.recMan.commit();
        }
        catch (Throwable t) {
            throw (NamingException)new NamingException("Failed to commit changes to the record manager.").initCause(t);
        }
    }

    public void addIndexOn(AttributeType spec, int cacheSize, int numDupLimit) throws NamingException {
        JdbmIndex idx = new JdbmIndex(spec, this.workingDirectory, cacheSize, numDupLimit);
        this.indices.put(spec.getOid(), idx);
    }

    public Index getExistanceIndex() {
        return this.existanceIdx;
    }

    public void setExistanceIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.existanceIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.existanceIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.existanceIdx);
    }

    public Index getHierarchyIndex() {
        return this.hierarchyIdx;
    }

    public void setHierarchyIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.hierarchyIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.hierarchyIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.hierarchyIdx);
    }

    public Index getAliasIndex() {
        return this.aliasIdx;
    }

    public void setAliasIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.aliasIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.aliasIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.aliasIdx);
    }

    public Index getOneAliasIndex() {
        return this.oneAliasIdx;
    }

    public void setOneAliasIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.oneAliasIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.oneAliasIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.oneAliasIdx);
    }

    public Index getSubAliasIndex() {
        return this.subAliasIdx;
    }

    public void setSubAliasIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.subAliasIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.subAliasIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.subAliasIdx);
    }

    public Index getUpdnIndex() {
        return this.updnIdx;
    }

    public void setUpdnIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.updnIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.updnIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.updnIdx);
    }

    public Index getNdnIndex() {
        return this.ndnIdx;
    }

    public void setNdnIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.ndnIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.ndnIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.ndnIdx);
    }

    public Iterator getUserIndices() {
        return this.indices.keySet().iterator();
    }

    public Iterator getSystemIndices() {
        return this.sysIndices.keySet().iterator();
    }

    public boolean hasUserIndexOn(String id) throws NamingException {
        return this.indices.containsKey(this.oidRegistry.getOid(id));
    }

    public boolean hasSystemIndexOn(String id) throws NamingException {
        return this.sysIndices.containsKey(this.oidRegistry.getOid(id));
    }

    public Index getUserIndex(String id) throws IndexNotFoundException {
        try {
            id = this.oidRegistry.getOid(id);
        }
        catch (NamingException e) {
            log.error("Failed to identify OID for: " + id, (Throwable)e);
            throw new IndexNotFoundException("Failed to identify OID for: " + id, id, (Throwable)e);
        }
        if (this.indices.containsKey(id)) {
            return this.indices.get(id);
        }
        String name = "unknown";
        try {
            name = this.oidRegistry.getPrimaryName(id);
        }
        catch (NamingException e) {
            String msg = "Failed to resolve primary name for " + id + " in user index lookup";
            log.error(msg, (Throwable)e);
            throw new IndexNotFoundException(msg, id, (Throwable)e);
        }
        throw new IndexNotFoundException("A user index on attribute " + id + " (" + name + ") does not exist!");
    }

    public Index getSystemIndex(String id) throws IndexNotFoundException {
        try {
            id = this.oidRegistry.getOid(id);
        }
        catch (NamingException e) {
            log.error("Failed to identify OID for: " + id, (Throwable)e);
            throw new IndexNotFoundException("Failed to identify OID for: " + id, id, (Throwable)e);
        }
        if (this.sysIndices.containsKey(id)) {
            return this.sysIndices.get(id);
        }
        String name = "unknown";
        try {
            name = this.oidRegistry.getPrimaryName(id);
        }
        catch (NamingException e) {
            String msg = "Failed to resolve primary name for " + id + " in user index lookup";
            log.error(msg, (Throwable)e);
            throw new IndexNotFoundException(msg, id, (Throwable)e);
        }
        throw new IndexNotFoundException("A system index on attribute " + id + " (" + name + ") does not exist!");
    }

    public Long getEntryId(String dn) throws NamingException {
        return (Long)this.ndnIdx.forwardLookup((Object)dn);
    }

    public String getEntryDn(Long id) throws NamingException {
        return (String)this.ndnIdx.reverseLookup((Object)id);
    }

    public Long getParentId(String dn) throws NamingException {
        Long childId = (Long)this.ndnIdx.forwardLookup((Object)dn);
        return (Long)this.hierarchyIdx.reverseLookup((Object)childId);
    }

    public Long getParentId(Long childId) throws NamingException {
        return (Long)this.hierarchyIdx.reverseLookup((Object)childId);
    }

    public String getEntryUpdn(Long id) throws NamingException {
        return (String)this.updnIdx.reverseLookup((Object)id);
    }

    public String getEntryUpdn(String dn) throws NamingException {
        Long id = (Long)this.ndnIdx.forwardLookup((Object)dn);
        return (String)this.updnIdx.reverseLookup((Object)id);
    }

    public int count() throws NamingException {
        return this.master.count();
    }

    private void dropAliasIndices(Long aliasId) throws NamingException {
        String targetDn = (String)this.aliasIdx.reverseLookup((Object)aliasId);
        Long targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        LdapDN ancestorDn = (LdapDN)new LdapDN(aliasDn).getPrefix(1);
        Long ancestorId = this.getEntryId(ancestorDn.toString());
        this.oneAliasIdx.drop((Object)ancestorId, (Object)targetId);
        this.subAliasIdx.drop((Object)ancestorId, (Object)targetId);
        while (!ancestorDn.equals((Object)this.normSuffix)) {
            ancestorDn = (LdapDN)ancestorDn.getPrefix(1);
            ancestorId = this.getEntryId(ancestorDn.toString());
            this.subAliasIdx.drop((Object)ancestorId, (Object)targetId);
        }
        this.aliasIdx.drop((Object)aliasId);
    }

    private void addAliasIndices(Long aliasId, LdapDN aliasDn, String aliasTarget) throws NamingException {
        LdapDN normalizedAliasTargetDn = null;
        Long targetId = null;
        LdapDN ancestorDn = null;
        Long ancestorId = null;
        normalizedAliasTargetDn = new LdapDN(aliasTarget);
        normalizedAliasTargetDn.normalize(this.attributeTypeRegistry.getNormalizerMapping());
        if (aliasDn.startsWith((Name)normalizedAliasTargetDn)) {
            if (aliasDn.equals((Object)normalizedAliasTargetDn)) {
                throw new NamingException("[36] aliasDereferencingProblem - attempt to create alias to itself.");
            }
            throw new NamingException("[36] aliasDereferencingProblem - attempt to create alias with cycle to relative " + aliasTarget + " not allowed from descendent alias " + aliasDn);
        }
        if (!normalizedAliasTargetDn.startsWith((Name)this.normSuffix)) {
            throw new NamingException("[36] aliasDereferencingProblem - the alias points to an entry outside of the " + this.upSuffix.getUpName() + " namingContext to an object whose existance cannot be" + " determined.");
        }
        targetId = (Long)this.ndnIdx.forwardLookup((Object)normalizedAliasTargetDn.toNormName());
        if (null == targetId) {
            throw new NamingException("[33] aliasProblem - the alias when dereferenced would not name a known object the aliasedObjectName must be set to a valid existing entry.");
        }
        if (null != this.aliasIdx.reverseLookup((Object)targetId)) {
            throw new NamingException("[36] aliasDereferencingProblem - the alias points to another alias.  Alias chaining is not supported by this backend.");
        }
        this.aliasIdx.add((Object)normalizedAliasTargetDn.getNormName(), (Object)aliasId);
        ancestorDn = (LdapDN)aliasDn.clone();
        ancestorDn.remove(aliasDn.size() - 1);
        ancestorId = this.getEntryId(ancestorDn.toNormName());
        if (!NamespaceTools.isSibling((Name)normalizedAliasTargetDn, (Name)aliasDn)) {
            this.oneAliasIdx.add((Object)ancestorId, (Object)targetId);
        }
        while (!ancestorDn.equals((Object)this.normSuffix) && null != ancestorId) {
            if (!NamespaceTools.isDescendant((Name)ancestorDn, (Name)normalizedAliasTargetDn)) {
                this.subAliasIdx.add((Object)ancestorId, (Object)targetId);
            }
            ancestorDn.remove(ancestorDn.size() - 1);
            ancestorId = this.getEntryId(ancestorDn.toNormName());
        }
    }

    public void add(LdapDN normName, Attributes entry) throws NamingException {
        Long parentId = null;
        Long id = this.master.getNextId();
        LdapDN parentDn = null;
        if (normName.equals((Object)this.normSuffix)) {
            parentId = 0L;
        } else {
            parentDn = (LdapDN)normName.clone();
            parentDn.remove(parentDn.size() - 1);
            parentId = this.getEntryId(parentDn.toString());
        }
        if (parentId == null) {
            throw new LdapNameNotFoundException("Id for parent '" + parentDn + "' not found!");
        }
        Attribute objectClass = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)OBJECT_CLASS_AT);
        if (objectClass == null) {
            String msg = "Entry " + normName.getUpName() + " contains no objectClass attribute: " + entry;
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
        if (objectClass.contains("alias")) {
            Attribute aliasAttr = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)ALIASED_OBJECT_NAME_AT);
            this.addAliasIndices(id, normName, (String)aliasAttr.get());
        }
        this.ndnIdx.add((Object)normName.toNormName(), (Object)id);
        this.updnIdx.add((Object)normName.getUpName(), (Object)id);
        this.hierarchyIdx.add((Object)parentId, (Object)id);
        NamingEnumeration<String> list = entry.getIDs();
        while (list.hasMore()) {
            String attributeId = list.next();
            String attributeOid = this.oidRegistry.getOid(attributeId);
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index idx = this.getUserIndex(attributeOid);
            NamingEnumeration<?> values = entry.get(attributeId).getAll();
            while (values.hasMore()) {
                idx.add(values.next(), (Object)id);
            }
            this.existanceIdx.add((Object)attributeOid, (Object)id);
        }
        this.master.put(entry, (Object)id);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    public Attributes lookup(Long id) throws NamingException {
        return this.master.get(id);
    }

    public void delete(Long id) throws NamingException {
        Attributes entry = this.lookup(id);
        Long parentId = this.getParentId(id);
        NamingEnumeration<String> attrs = entry.getIDs();
        Attribute objectClass = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)OBJECT_CLASS_AT);
        if (objectClass.contains("alias")) {
            this.dropAliasIndices(id);
        }
        this.ndnIdx.drop((Object)id);
        this.updnIdx.drop((Object)id);
        this.hierarchyIdx.drop((Object)id);
        if (!parentId.equals(0L)) {
            this.hierarchyIdx.drop((Object)parentId, (Object)id);
        }
        while (attrs.hasMore()) {
            String attributeId = attrs.next();
            String attributeOid = this.oidRegistry.getOid(attributeId);
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index index = this.getUserIndex(attributeOid);
            NamingEnumeration<?> values = entry.get(attributeId).getAll();
            while (values.hasMore()) {
                index.drop(values.next(), (Object)id);
            }
            this.existanceIdx.drop((Object)attributeOid, (Object)id);
        }
        this.master.delete(id);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    public NamingEnumeration list(Long id) throws NamingException {
        return this.hierarchyIdx.listIndices((Object)id);
    }

    public int getChildCount(Long id) throws NamingException {
        return this.hierarchyIdx.count((Object)id);
    }

    public LdapDN getSuffix() {
        return this.normSuffix;
    }

    public LdapDN getUpSuffix() {
        return this.upSuffix;
    }

    public Attributes getSuffixEntry() throws NamingException {
        Long id = this.getEntryId(this.normSuffix.toNormName());
        if (null == id) {
            return null;
        }
        return this.lookup(id);
    }

    public void setProperty(String propertyName, String propertyValue) throws NamingException {
        this.master.setProperty(propertyName, propertyValue);
    }

    public String getProperty(String propertyName) throws NamingException {
        return this.master.getProperty(propertyName);
    }

    public Attributes getIndices(Long id) throws NamingException {
        IndexRecord rec;
        AttributesImpl attributes = new AttributesImpl();
        attributes.put("_nDn", this.getEntryDn(id));
        attributes.put("_upDn", this.getEntryUpdn(id));
        attributes.put("_parent", this.getParentId(id));
        for (Index index : this.indices.values()) {
            IndexEnumeration list = index.listReverseIndices((Object)id);
            while (list.hasMore()) {
                rec = (IndexRecord)list.next();
                Object val = rec.getIndexKey();
                String attrId = index.getAttribute().getName();
                Attribute attr = attributes.get(attrId);
                if (attr == null) {
                    attr = new AttributeImpl(attrId);
                }
                attr.add(val);
                attributes.put(attr);
            }
        }
        IndexEnumeration list = this.existanceIdx.listReverseIndices((Object)id);
        StringBuffer val = new StringBuffer();
        while (list.hasMore()) {
            IndexRecord rec2 = (IndexRecord)list.next();
            val.append("_existance[");
            val.append(rec2.getIndexKey());
            val.append("]");
            String valStr = val.toString();
            Attribute attr = attributes.get(valStr);
            if (attr == null) {
                attr = new AttributeImpl(valStr);
            }
            attr.add(rec2.getEntryId());
            attributes.put(attr);
            val.setLength(0);
        }
        list = this.hierarchyIdx.listIndices((Object)id);
        AttributeImpl childAttr = new AttributeImpl("_child");
        attributes.put((Attribute)childAttr);
        while (list.hasMore()) {
            rec = (IndexRecord)list.next();
            childAttr.add(rec.getEntryId());
        }
        return attributes;
    }

    private void add(Long id, Attributes entry, Attribute mods) throws NamingException {
        AttributeType type;
        Attribute entryAttrToAddTo;
        String modsOid = this.oidRegistry.getOid(mods.getID());
        if (this.hasUserIndexOn(modsOid)) {
            Index idx = this.getUserIndex(modsOid);
            idx.add(mods, (Object)id);
            if (!this.existanceIdx.hasValue((Object)modsOid, (Object)id)) {
                this.existanceIdx.add((Object)modsOid, (Object)id);
            }
        }
        if ((entryAttrToAddTo = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)(type = this.attributeTypeRegistry.lookup(modsOid)))) == null) {
            entryAttrToAddTo = new AttributeImpl(mods.getID());
            entry.put(entryAttrToAddTo);
        }
        for (int ii = 0; ii < mods.size(); ++ii) {
            entryAttrToAddTo.add(mods.get(ii));
        }
        if (modsOid.equals(this.oidRegistry.getOid("aliasedObjectName"))) {
            String ndnStr = (String)this.ndnIdx.reverseLookup((Object)id);
            this.addAliasIndices(id, new LdapDN(ndnStr), (String)mods.get());
        }
    }

    private void remove(Long id, Attributes entry, Attribute mods) throws NamingException {
        String modsOid = this.oidRegistry.getOid(mods.getID());
        if (this.hasUserIndexOn(modsOid)) {
            Index idx = this.getUserIndex(modsOid);
            idx.drop(mods, (Object)id);
            if (null == idx.reverseLookup((Object)id)) {
                this.existanceIdx.drop((Object)modsOid, (Object)id);
            }
        }
        AttributeType attrType = this.attributeTypeRegistry.lookup(modsOid);
        if (mods.size() == 0) {
            AttributeUtils.removeAttribute((AttributeType)attrType, (Attributes)entry);
        } else {
            Attribute entryAttr = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)attrType);
            NamingEnumeration<?> values = mods.getAll();
            while (values.hasMore()) {
                entryAttr.remove(values.next());
            }
            if (entryAttr.size() == 0) {
                entry.remove(entryAttr.getID());
            }
        }
        if (modsOid.equals(this.oidRegistry.getOid("aliasedObjectName"))) {
            this.dropAliasIndices(id);
        }
    }

    private void replace(Long id, Attributes entry, Attribute mods) throws NamingException {
        String aliasAttributeOid;
        String modsOid = this.oidRegistry.getOid(mods.getID());
        if (this.hasUserIndexOn(modsOid)) {
            Index idx = this.getUserIndex(modsOid);
            idx.drop((Object)id);
            idx.add(mods, (Object)id);
            if (null == idx.reverseLookup((Object)id)) {
                this.existanceIdx.drop((Object)modsOid, (Object)id);
            }
        }
        if (modsOid.equals(aliasAttributeOid = this.oidRegistry.getOid("aliasedObjectName"))) {
            this.dropAliasIndices(id);
        }
        if (mods.size() > 0) {
            entry.put(mods);
        } else {
            entry.remove(mods.getID());
        }
        if (modsOid.equals(aliasAttributeOid) && mods.size() > 0) {
            String ndnStr = (String)this.ndnIdx.reverseLookup((Object)id);
            this.addAliasIndices(id, new LdapDN(ndnStr), (String)mods.get());
        }
    }

    public void modify(LdapDN dn, int modOp, Attributes mods) throws NamingException {
        NamingEnumeration<String> attrs = null;
        Long id = this.getEntryId(dn.toString());
        Attributes entry = this.master.get(id);
        switch (modOp) {
            case 1: {
                attrs = mods.getIDs();
                while (attrs.hasMore()) {
                    String attrId = attrs.next();
                    Attribute attr = mods.get(attrId);
                    this.add(id, entry, attr);
                }
                break;
            }
            case 3: {
                attrs = mods.getIDs();
                while (attrs.hasMore()) {
                    String attrId = attrs.next();
                    Attribute attr = mods.get(attrId);
                    this.remove(id, entry, attr);
                }
                break;
            }
            case 2: {
                attrs = mods.getIDs();
                while (attrs.hasMore()) {
                    String attrId = attrs.next();
                    Attribute attr = mods.get(attrId);
                    this.replace(id, entry, attr);
                }
                break;
            }
            default: {
                throw new NamingException("Unidentified modification operation");
            }
        }
        this.master.put(entry, (Object)id);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    public void modify(LdapDN dn, ModificationItemImpl[] mods) throws NamingException {
        Long id = this.getEntryId(dn.toString());
        Attributes entry = this.master.get(id);
        block5: for (int ii = 0; ii < mods.length; ++ii) {
            Attribute attrMods = mods[ii].getAttribute();
            switch (mods[ii].getModificationOp()) {
                case 1: {
                    this.add(id, entry, attrMods);
                    continue block5;
                }
                case 3: {
                    this.remove(id, entry, attrMods);
                    continue block5;
                }
                case 2: {
                    this.replace(id, entry, attrMods);
                    continue block5;
                }
                default: {
                    throw new NamingException("Unidentified modification operation");
                }
            }
        }
        this.master.put(entry, (Object)id);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    public void rename(LdapDN dn, String newRdn, boolean deleteOldRdn) throws NamingException {
        String newRdnAttr = NamespaceTools.getRdnAttribute((String)newRdn);
        String newRdnValue = NamespaceTools.getRdnValue((String)newRdn);
        Long id = this.getEntryId(dn.toString());
        Attributes entry = this.lookup(id);
        LdapDN updn = new LdapDN(this.getEntryUpdn(id));
        String newRdnAttrOid = this.oidRegistry.getOid(newRdnAttr);
        AttributeType newRdnAttrType = this.attributeTypeRegistry.lookup(newRdnAttrOid);
        Attribute rdnAttr = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)newRdnAttrType);
        if (rdnAttr == null) {
            rdnAttr = new AttributeImpl(newRdnAttr);
        }
        if (!rdnAttr.contains(newRdnValue)) {
            rdnAttr.add(newRdnValue);
        }
        entry.put(rdnAttr);
        if (this.hasUserIndexOn(newRdnAttrOid)) {
            Index idx = this.getUserIndex(newRdnAttrOid);
            idx.add((Object)newRdnValue, (Object)id);
            if (!this.existanceIdx.hasValue((Object)newRdnAttrOid, (Object)id)) {
                this.existanceIdx.add((Object)newRdnAttrOid, (Object)id);
            }
        }
        if (deleteOldRdn) {
            String oldRdn = updn.get(updn.size() - 1);
            String oldRdnAttr = NamespaceTools.getRdnAttribute((String)oldRdn);
            String oldRdnAttrOid = this.oidRegistry.getOid(oldRdnAttr);
            String oldRdnValue = NamespaceTools.getRdnValue((String)oldRdn);
            AttributeType oldRdnAttrType = this.attributeTypeRegistry.lookup(oldRdnAttrOid);
            AttributeUtils.getAttribute((Attributes)entry, (AttributeType)oldRdnAttrType).remove(oldRdnValue);
            if (this.hasUserIndexOn(oldRdnAttrOid)) {
                Index idx = this.getUserIndex(oldRdnAttrOid);
                idx.drop((Object)oldRdnValue, (Object)id);
                if (null == idx.reverseLookup((Object)id)) {
                    this.existanceIdx.drop((Object)oldRdnAttrOid, (Object)id);
                }
            }
        }
        LdapDN newUpdn = (LdapDN)updn.clone();
        newUpdn.remove(newUpdn.size() - 1);
        newUpdn.add(newUpdn.size(), newRdn);
        this.modifyDn(id, newUpdn, false);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    private void modifyDn(Long id, LdapDN updn, boolean isMove) throws NamingException {
        String aliasTarget = null;
        this.ndnIdx.drop((Object)id);
        LdapDN normalizedDn = updn.isNormalized() ? updn : LdapDN.normalize((LdapDN)updn, (Map)this.attributeTypeRegistry.getNormalizerMapping());
        this.ndnIdx.add(this.ndnIdx.getNormalized((Object)normalizedDn.toNormName()), (Object)id);
        this.updnIdx.drop((Object)id);
        this.updnIdx.add((Object)updn.getUpName(), (Object)id);
        if (isMove && null != (aliasTarget = (String)this.aliasIdx.reverseLookup((Object)id))) {
            this.addAliasIndices(id, new LdapDN(this.getEntryDn(id)), aliasTarget);
        }
        NamingEnumeration children = this.list(id);
        while (children.hasMore()) {
            IndexRecord rec = (IndexRecord)children.next();
            Long childId = (Long)rec.getEntryId();
            LdapDN childUpdn = (LdapDN)updn.clone();
            LdapDN oldUpdn = new LdapDN(this.getEntryUpdn(childId));
            String rdn = oldUpdn.get(oldUpdn.size() - 1);
            childUpdn.add(childUpdn.size(), rdn);
            this.modifyDn(childId, childUpdn, isMove);
        }
    }

    public void move(LdapDN oldChildDn, LdapDN newParentDn, String newRdn, boolean deleteOldRdn) throws NamingException {
        Long childId = this.getEntryId(oldChildDn.toString());
        this.rename(oldChildDn, newRdn, deleteOldRdn);
        this.move(oldChildDn, childId, newParentDn);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    public void move(LdapDN oldChildDn, LdapDN newParentDn) throws NamingException {
        Long childId = this.getEntryId(oldChildDn.toString());
        this.move(oldChildDn, childId, newParentDn);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    private void move(LdapDN oldChildDn, Long childId, LdapDN newParentDn) throws NamingException {
        Long newParentId = this.getEntryId(newParentDn.toString());
        Long oldParentId = this.getParentId(childId);
        this.dropMovedAliasIndices(oldChildDn);
        this.hierarchyIdx.drop((Object)oldParentId, (Object)childId);
        this.hierarchyIdx.add((Object)newParentId, (Object)childId);
        LdapDN childUpdn = new LdapDN(this.getEntryUpdn(childId));
        String childRdn = childUpdn.get(childUpdn.size() - 1);
        LdapDN newUpdn = new LdapDN(this.getEntryUpdn(newParentId));
        newUpdn.add(newUpdn.size(), childRdn);
        this.modifyDn(childId, newUpdn, true);
    }

    private void dropMovedAliasIndices(final LdapDN movedBase) throws NamingException {
        IndexAssertion isBaseDescendant = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord rec) throws NamingException {
                String dn = JdbmStore.this.getEntryDn((Long)rec.getEntryId());
                return dn.endsWith(movedBase.toString());
            }
        };
        Long movedBaseId = this.getEntryId(movedBase.toString());
        if (this.aliasIdx.reverseLookup((Object)movedBaseId) != null) {
            this.dropAliasIndices(movedBaseId, movedBase);
        }
        IndexAssertionEnumeration aliases = new IndexAssertionEnumeration((NamingEnumeration)this.aliasIdx.listIndices((Object)movedBase.toString(), true), isBaseDescendant);
        while (aliases.hasMore()) {
            IndexRecord entry = (IndexRecord)aliases.next();
            this.dropAliasIndices((Long)entry.getEntryId(), movedBase);
        }
    }

    private void dropAliasIndices(Long aliasId, LdapDN movedBase) throws NamingException {
        String targetDn = (String)this.aliasIdx.reverseLookup((Object)aliasId);
        Long targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        LdapDN ancestorDn = (LdapDN)movedBase.getPrefix(1);
        Long ancestorId = this.getEntryId(ancestorDn.toString());
        if (aliasDn.equals(movedBase.toString())) {
            this.oneAliasIdx.drop((Object)ancestorId, (Object)targetId);
        }
        this.subAliasIdx.drop((Object)ancestorId, (Object)targetId);
        while (!ancestorDn.equals((Object)this.upSuffix)) {
            ancestorDn = (LdapDN)ancestorDn.getPrefix(1);
            ancestorId = this.getEntryId(ancestorDn.toString());
            this.subAliasIdx.drop((Object)ancestorId, (Object)targetId);
        }
    }

    public void initRegistries(Registries registries) {
        this.attributeTypeRegistry = registries.getAttributeTypeRegistry();
        this.oidRegistry = registries.getOidRegistry();
    }
}

