/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.media;

import com.google.api.client.googleapis.media.MediaHttpDownloaderProgressListener;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.BackOffPolicy;
import com.google.api.client.http.ExponentialBackOffPolicy;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public final class MediaHttpDownloader {
    public static final int MAXIMUM_CHUNK_SIZE = 0x2000000;
    private final HttpRequestFactory requestFactory;
    private final HttpTransport transport;
    private boolean backOffPolicyEnabled = true;
    private boolean directDownloadEnabled = false;
    private MediaHttpDownloaderProgressListener progressListener;
    private int chunkSize = 0x2000000;
    private long mediaContentLength;
    private DownloadState downloadState = DownloadState.NOT_STARTED;
    private long bytesDownloaded;

    public MediaHttpDownloader(HttpTransport transport, HttpRequestInitializer httpRequestInitializer) {
        this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
    }

    public void download(GenericUrl requestUrl, OutputStream outputStream) throws IOException {
        this.download(requestUrl, null, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(GenericUrl requestUrl, HttpHeaders requestHeaders, OutputStream outputStream) throws IOException {
        Preconditions.checkArgument((this.downloadState == DownloadState.NOT_STARTED ? 1 : 0) != 0);
        requestUrl.put("alt", (Object)"media");
        if (this.directDownloadEnabled) {
            this.updateStateAndNotifyListener(DownloadState.MEDIA_IN_PROGRESS);
            HttpRequest request = this.requestFactory.buildGetRequest(requestUrl);
            if (requestHeaders != null) {
                request.getHeaders().putAll((Map)requestHeaders);
            }
            if (this.bytesDownloaded != 0L) {
                request.getHeaders().setRange("bytes=" + this.bytesDownloaded + "-");
            }
            HttpResponse response = request.execute();
            try {
                this.bytesDownloaded = this.mediaContentLength = response.getHeaders().getContentLength().longValue();
                this.updateStateAndNotifyListener(DownloadState.MEDIA_COMPLETE);
                AbstractInputStreamContent.copy((InputStream)response.getContent(), (OutputStream)outputStream);
            }
            finally {
                response.disconnect();
            }
            return;
        }
        while (true) {
            HttpRequest request = this.requestFactory.buildGetRequest(requestUrl);
            if (requestHeaders != null) {
                request.getHeaders().putAll((Map)requestHeaders);
            }
            request.getHeaders().setRange("bytes=" + this.bytesDownloaded + "-" + (this.bytesDownloaded + (long)this.chunkSize - 1L));
            if (this.backOffPolicyEnabled) {
                request.setBackOffPolicy((BackOffPolicy)new ExponentialBackOffPolicy());
            }
            HttpResponse response = request.execute();
            AbstractInputStreamContent.copy((InputStream)response.getContent(), (OutputStream)outputStream);
            String contentRange = response.getHeaders().getContentRange();
            long nextByteIndex = this.getNextByteIndex(contentRange);
            this.setMediaContentLength(contentRange);
            if (this.mediaContentLength <= nextByteIndex) {
                this.bytesDownloaded = this.mediaContentLength;
                this.updateStateAndNotifyListener(DownloadState.MEDIA_COMPLETE);
                return;
            }
            this.bytesDownloaded = nextByteIndex;
            this.updateStateAndNotifyListener(DownloadState.MEDIA_IN_PROGRESS);
        }
    }

    private long getNextByteIndex(String rangeHeader) {
        if (rangeHeader == null) {
            return 0L;
        }
        return Long.parseLong(rangeHeader.substring(rangeHeader.indexOf(45) + 1, rangeHeader.indexOf(47))) + 1L;
    }

    public MediaHttpDownloader setBytesDownloaded(long bytesDownloaded) {
        this.bytesDownloaded = bytesDownloaded;
        return this;
    }

    private void setMediaContentLength(String rangeHeader) {
        if (rangeHeader == null) {
            return;
        }
        if (this.mediaContentLength == 0L) {
            this.mediaContentLength = Long.parseLong(rangeHeader.substring(rangeHeader.indexOf(47) + 1));
        }
    }

    public boolean isDirectDownloadEnabled() {
        return this.directDownloadEnabled;
    }

    public MediaHttpDownloader setDirectDownloadEnabled(boolean directDownloadEnabled) {
        this.directDownloadEnabled = directDownloadEnabled;
        return this;
    }

    public MediaHttpDownloader setProgressListener(MediaHttpDownloaderProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public MediaHttpDownloaderProgressListener getProgressListener() {
        return this.progressListener;
    }

    public MediaHttpDownloader setBackOffPolicyEnabled(boolean backOffPolicyEnabled) {
        this.backOffPolicyEnabled = backOffPolicyEnabled;
        return this;
    }

    public boolean isBackOffPolicyEnabled() {
        return this.backOffPolicyEnabled;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public MediaHttpDownloader setChunkSize(int chunkSize) {
        Preconditions.checkArgument((chunkSize > 0 && chunkSize <= 0x2000000 ? 1 : 0) != 0);
        this.chunkSize = chunkSize;
        return this;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public long getNumBytesDownloaded() {
        return this.bytesDownloaded;
    }

    private void updateStateAndNotifyListener(DownloadState downloadState) throws IOException {
        this.downloadState = downloadState;
        if (this.progressListener != null) {
            this.progressListener.progressChanged(this);
        }
    }

    public DownloadState getDownloadState() {
        return this.downloadState;
    }

    public double getProgress() {
        return this.mediaContentLength == 0L ? 0.0 : (double)this.bytesDownloaded / (double)this.mediaContentLength;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DownloadState {
        NOT_STARTED,
        MEDIA_IN_PROGRESS,
        MEDIA_COMPLETE;

    }
}

