/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.app.DefaultContext;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.ModuleResource;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;

public class ModuleRoot
extends DefaultObject
implements ModuleResource {
    protected HttpServletRequest request;
    protected UriInfo uriInfo;
    protected HttpHeaders httpHeaders;

    @Context
    public void setUriInfo(UriInfo info) {
        this.uriInfo = info;
        if (this.request != null && this.httpHeaders != null) {
            this.init();
        }
    }

    @Context
    public void setHttpHeaders(HttpHeaders headers) {
        this.httpHeaders = headers;
        if (this.request != null && this.uriInfo != null) {
            this.init();
        }
    }

    @Context
    public void setHttpRequest(HttpServletRequest request) {
        this.request = request;
        if (this.uriInfo != null && this.httpHeaders != null) {
            this.init();
        }
    }

    private void init() {
        DefaultContext ctx = (DefaultContext)this.request.getAttribute(WebContext.class.getName());
        if (ctx == null) {
            throw new IllegalStateException("No WebContext found in http request! You should install the WebEngineFilter");
        }
        ctx.setHttpHeaders(this.httpHeaders);
        ctx.setUriInfo(this.uriInfo);
        Module module = this.findModule(ctx);
        ResourceType type = module.getType(this.getClass().getAnnotation(WebObject.class).type());
        ctx.setModule(module);
        this.initialize(ctx, type, new Object[0]);
        this.setRoot(true);
        ctx.push(this);
    }

    private Module findModule(DefaultContext ctx) {
        Path path = this.getClass().getAnnotation(Path.class);
        if (path == null) {
            throw new IllegalStateException("ModuleRoot not annotated with @Path: " + this.getClass());
        }
        ModuleConfiguration mc = ctx.getEngine().getModuleManager().getModuleByRootClass(this.getClass());
        if (mc == null) {
            throw new IllegalStateException("No module found for root resource: " + this.getClass());
        }
        return mc.get();
    }

    @GET
    @Path(value="skin/{path:.*}")
    public Response getSkinResource(@PathParam(value="path") String path) {
        try {
            ScriptFile file = this.getModule().getSkinResource("/resources/" + path);
            if (file != null) {
                long lastModified = file.lastModified();
                Response.ResponseBuilder resp = Response.ok((Object)file.getFile()).lastModified(new Date(lastModified)).header("Cache-Control", (Object)"public").header("Server", (Object)"Nuxeo/WebEngine-1.0");
                String mimeType = this.ctx.getEngine().getMimeType(file.getExtension());
                if (mimeType == null) {
                    mimeType = "text/plain";
                }
                resp.type(mimeType);
                return resp.build();
            }
        }
        catch (IOException e) {
            throw WebException.wrap("Failed to get resource file: " + path, e);
        }
        return Response.status((int)404).build();
    }

    @Override
    public String getLink(DocumentModel doc) {
        return this.getPath() + "/@nxdoc/" + doc.getId();
    }

    @Override
    public Object handleError(WebApplicationException e) {
        return e;
    }
}

