/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.vocabularies;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Registrable;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.vocabularies.Vocabulary;
import org.nuxeo.theme.vocabularies.VocabularyItem;
import org.nuxeo.theme.vocabularies.VocabularyType;

public final class VocabularyManager
implements Registrable {
    private static final Log log = LogFactory.getLog(VocabularyManager.class);
    private final Map<String, Vocabulary> vocabularies = new HashMap<String, Vocabulary>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<VocabularyItem> getItems(String name) {
        VocabularyType vocabularyType = (VocabularyType)Manager.getTypeRegistry().lookup(TypeFamily.VOCABULARY, name);
        if (vocabularyType == null) {
            return null;
        }
        String path = vocabularyType.getPath();
        String className = vocabularyType.getClassName();
        if (path == null && className == null) {
            log.error((Object)("Must specify a class name or a path for vocabulary: " + name));
            return null;
        }
        if (path != null && className != null) {
            log.error((Object)("Cannot specify both a class name and a path for vocabulary: " + name));
            return null;
        }
        if (className != null) {
            Vocabulary vocabulary = this.getInstance(className);
            if (vocabulary != null) return vocabulary.getItems();
            log.error((Object)("Vocabulary class not found: " + className));
            return null;
        }
        if (path == null) return null;
        if (!path.endsWith(".csv")) {
            log.error((Object)("Only .csv vocabularies are supported: " + path));
            return null;
        }
        ArrayList<VocabularyItem> items = new ArrayList<VocabularyItem>();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);){
            if (is == null) {
                log.error((Object)("Vocabulary file not found: " + path));
                List<VocabularyItem> list = null;
                return list;
            }
            try (CSVParser reader = new CSVParser((Reader)new InputStreamReader(is, Charsets.UTF_8), CSVFormat.DEFAULT);){
                Iterator iterator = reader.iterator();
                while (iterator.hasNext()) {
                    String value;
                    CSVRecord record = (CSVRecord)iterator.next();
                    String label = value = record.get(0);
                    if (record.size() >= 2) {
                        label = record.get(1);
                    }
                    items.add(new VocabularyItem(value, label));
                }
                return items;
            }
        }
        catch (IOException e) {
            log.error((Object)("Could not read vocabulary file: " + path), (Throwable)e);
        }
        return items;
    }

    private Vocabulary getInstance(String className) {
        Vocabulary vocabulary = this.vocabularies.get(className);
        if (vocabulary == null) {
            try {
                vocabulary = (Vocabulary)Class.forName(className).newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)("Could not instantiate vocabulary: " + className));
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Could not instantiate vocabulary: " + className));
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Could not instantiate vocabulary: " + className));
            }
        }
        if (vocabulary != null) {
            this.vocabularies.put(className, vocabulary);
        }
        return vocabulary;
    }

    @Override
    public void clear() {
    }
}

