/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.file.FileCache;
import org.nuxeo.common.file.LRUFileCache;
import org.nuxeo.common.utils.SizeUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.binary.AbstractBinaryManager;
import org.nuxeo.ecm.core.storage.binary.Binary;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerDescriptor;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerRootDescriptor;
import org.nuxeo.ecm.core.storage.binary.FileStorage;
import org.nuxeo.ecm.core.storage.binary.LazyBinary;
import org.nuxeo.runtime.api.Framework;

public abstract class CachingBinaryManager
extends AbstractBinaryManager {
    private static final Log log = LogFactory.getLog(CachingBinaryManager.class);
    protected static final String LEN_DIGEST_SUFFIX = "-len";
    protected File cachedir;
    public FileCache fileCache;
    protected FileStorage fileStorage;

    @Override
    public void initialize(BinaryManagerDescriptor binaryManagerDescriptor) throws IOException {
        super.initialize(binaryManagerDescriptor);
        this.repositoryName = binaryManagerDescriptor.repositoryName;
        this.descriptor = new BinaryManagerRootDescriptor();
        this.descriptor.digest = this.getDefaultDigestAlgorithm();
        log.info((Object)("Repository '" + this.repositoryName + "' using " + this.getClass().getSimpleName()));
    }

    public void initializeCache(File dir, long maxSize, FileStorage fileStorage) {
        this.fileCache = new LRUFileCache(dir, maxSize);
        this.fileStorage = fileStorage;
    }

    public void initializeCache(String cacheSizeStr, FileStorage fileStorage) throws IOException {
        this.cachedir = File.createTempFile("nxbincache.", "", null);
        this.cachedir.delete();
        this.cachedir.mkdir();
        long cacheSize = SizeUtils.parseSizeInBytes((String)cacheSizeStr);
        this.initializeCache(this.cachedir, cacheSize, fileStorage);
        log.info((Object)("Using binary cache directory: " + this.cachedir.getPath() + " size: " + cacheSizeStr));
    }

    @Override
    public void close() {
        this.fileCache.clear();
        if (this.cachedir != null) {
            try {
                FileUtils.deleteDirectory((File)this.cachedir);
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binary getBinary(InputStream in) throws IOException {
        String digest;
        File tmp = this.fileCache.getTempFile();
        FileOutputStream out = new FileOutputStream(tmp);
        try {
            digest = this.storeAndDigest(in, out);
        }
        finally {
            in.close();
            ((OutputStream)out).close();
        }
        long length = tmp.length();
        File cachedFile = this.fileCache.getFile(digest);
        if (cachedFile != null) {
            if (Framework.isTestModeSet()) {
                Framework.getProperties().setProperty("cachedBinary", digest);
            }
            tmp.delete();
        } else {
            this.fileStorage.storeFile(digest, tmp);
            this.fileCache.putFile(digest, tmp);
        }
        return new LazyBinary(digest, length, this.repositoryName, this);
    }

    @Override
    public Binary getBinary(String digest) {
        return new LazyBinary(digest, this.repositoryName, this);
    }

    public File getFile(String digest) throws IOException {
        File file = this.fileCache.getFile(digest);
        if (file != null) {
            return file;
        }
        File tmp = this.fileCache.getTempFile();
        if (this.fileStorage.fetchFile(digest, tmp)) {
            file = this.fileCache.putFile(digest, tmp);
            return file;
        }
        tmp.delete();
        return null;
    }

    public Long getLength(String digest) throws IOException {
        Long length = this.getLengthFromCache(digest);
        if (length != null) {
            return length;
        }
        length = this.fileStorage.fetchLength(digest);
        this.putLengthInCache(digest, length);
        return length;
    }

    protected Long getLengthFromCache(String digest) throws IOException {
        Long l;
        File f = this.fileCache.getFile(digest + LEN_DIGEST_SUFFIX);
        if (f == null) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            String len = IOUtils.toString((InputStream)in);
            l = Long.valueOf(len);
        }
        catch (NumberFormatException e) {
            try {
                throw new IOException("Invalid length in " + f, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putLengthInCache(String digest, Long len) throws IOException {
        if (len == null) {
            return;
        }
        FileOutputStream out = null;
        try {
            File tmp = this.fileCache.getTempFile();
            out = new FileOutputStream(tmp);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(len.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            this.fileCache.putFile(digest + LEN_DIGEST_SUFFIX, tmp);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }
}

