/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.Component;

public class Namespace {
    private String name;
    private Map<String, Namespace> children = new HashMap<String, Namespace>();

    public Namespace(String name) {
        this.name = name;
    }

    public Object get(String key) {
        Object component = this.getComponentInstance(key);
        return component == null ? this.children.get(key) : component;
    }

    public Namespace getChild(String key) {
        return this.children.get(key);
    }

    public Namespace getOrCreateChild(String key) {
        Namespace result = this.getChild(key);
        if (result == null) {
            result = new Namespace(this.qualifyName(key) + '.');
            this.addChild(key, result);
        }
        return result;
    }

    public Object getComponentInstance(String key) {
        return this.getComponentInstance(key, true);
    }

    public Object getComponentInstance(String key, boolean create) {
        return Component.getInstance(this.qualifyName(key), create);
    }

    public Object getComponentInstance(String key, boolean create, boolean allowAutocreation) {
        return Component.getInstance(this.qualifyName(key), create, allowAutocreation);
    }

    private String qualifyName(String key) {
        return this.name == null ? key : this.name + key;
    }

    public boolean hasChild(String key) {
        return this.children.containsKey(key);
    }

    public void addChild(String name, Namespace value) {
        this.children.put(name, value);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Namespace)) {
            return false;
        }
        Namespace ns = (Namespace)other;
        return this.name == ns.name || this.name != null && this.name.equals(ns.name);
    }

    public String toString() {
        return "Namespace(" + (this.name == null ? "Root" : this.name) + ')';
    }
}

