/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf.concurrency;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Manager;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.jsf.concurrency.ConcurrentRequestResolver;

public abstract class AbstractResolver
implements ConcurrentRequestResolver {
    private static final Log log = LogFactory.getLog(AbstractResolver.class);

    protected boolean handleNoResponse(HttpServletResponse response) {
        response.setStatus(204);
        FacesContext.getCurrentInstance().responseComplete();
        return false;
    }

    protected boolean handleRedirect(ConversationEntry ce, HttpServletResponse response, String url) {
        try {
            if (!url.contains("=" + ce.getId())) {
                StringBuilder builder = new StringBuilder().append(url).append(url.contains("?") ? (char)'&' : '?').append(Manager.instance().getConversationIdParameter()).append('=').append(ce.getId());
                url = builder.toString();
            }
            response.sendRedirect(url);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        FacesContext.getCurrentInstance().responseComplete();
        return true;
    }

    protected void addTransientMessage(StatusMessage.Severity severity, String keyMessage, String defaultMessage) {
        FacesMessages.addTransientMessage(new StatusMessage(severity, keyMessage, defaultMessage, keyMessage, defaultMessage));
    }
}

