/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.core.reindexing.docs.automation;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.opentoutatice.elasticsearch.core.reindexing.docs.es.state.EsState;
import org.opentoutatice.elasticsearch.core.reindexing.docs.es.state.EsStateChecker;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.IndexNAliasManager;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.ReIndexingRunnerManager;
import org.opentoutatice.elasticsearch.utils.MessageUtils;

@Operation(id="Documents.CleanESIndices", category="Services")
public class CleanESIndices {
    public static final String ID = "Documents.CleanESIndices";
    private static final Log log = LogFactory.getLog(CleanESIndices.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public StringBlob run() throws Exception {
        String cleaningStatus = null;
        CleanESIndices cleanESIndices = this;
        synchronized (cleanESIndices) {
            boolean reIndexingInProgress;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Es indices [CLEANING] started ...");
            }
            if (!(reIndexingInProgress = ReIndexingRunnerManager.get().isReIndexingInProgress())) {
                Collection<String> orphanIndices = CleanESIndices.getOrphanIndices();
                if (orphanIndices.size() > 0) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Found [%s] orphan indices: [%s]: cleaning ...", orphanIndices.size(), MessageUtils.listToString(orphanIndices)));
                    }
                    for (String orphanIndex : orphanIndices) {
                        IndexNAliasManager.get().deleteIndex(orphanIndex);
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)String.format("Index [%s] deleted", orphanIndex));
                    }
                    EsState newEsState = EsStateChecker.get().getEsState();
                    cleaningStatus = String.format("[%s] orphan indices deleted: [%s] %s New %s", orphanIndices.size(), MessageUtils.listToString(orphanIndices), System.lineSeparator(), newEsState.toString());
                } else {
                    cleaningStatus = "Found no orphan indices to clean.";
                }
            } else {
                cleaningStatus = "One Zero Down Time Re-Indexing process is in progress: you can not clean indices for the moment.";
            }
            if (log.isInfoEnabled()) {
                log.info((Object)cleaningStatus);
            }
        }
        return new StringBlob(cleaningStatus);
    }

    public static Collection<String> getOrphanIndices() throws InterruptedException, ExecutionException {
        EsState esState = EsStateChecker.get().getEsState();
        if (log.isInfoEnabled()) {
            log.info((Object)esState.toString());
        }
        Map<String, List<String>> aliases = esState.getAliases();
        HashSet linkedIndices = new HashSet();
        for (Map.Entry<String, List<String>> alias : aliases.entrySet()) {
            linkedIndices.addAll(alias.getValue());
        }
        List<String> indices = esState.getIndices();
        return CollectionUtils.disjunction(indices, linkedIndices);
    }
}

