/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.scanner.config;

import java.io.Serializable;
import java.util.Map;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.scheduler.Schedule;
import org.nuxeo.ecm.core.scheduler.SchedulerService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.opentoutatice.ecm.scanner.AbstractScanUpdater;
import org.opentoutatice.ecm.scanner.config.ScanUpdaterConfiguration;
import org.opentoutatice.ecm.scanner.config.ScannerConfiguration;
import org.opentoutatice.ecm.scanner.config.ScannerConfigurationRegistryImpl;
import org.opentoutatice.ecm.scanner.config.ScannerConfigurationService;
import org.opentoutatice.ecm.scanner.directive.Directive;
import org.opentoutatice.ecm.scanner.directive.DirectiveException;
import org.opentoutatice.ecm.scanner.directive.DirectiveFactory;
import org.opentoutatice.ecm.scanner.directive.DirectiveFactoryImpl;
import org.opentoutatice.ecm.scanner.directive.DirectiveType;

public class ScannerConfigurationServiceImpl
extends DefaultComponent
implements ScannerConfigurationService {
    private SchedulerService schedulerService;
    private DirectiveFactory directiveFactory;
    private ScannerConfigurationRegistryImpl configRegistry;

    public void activate(ComponentContext context) throws Exception {
        if (this.schedulerService == null) {
            this.schedulerService = (SchedulerService)Framework.getService(SchedulerService.class);
        }
        this.configRegistry = new ScannerConfigurationRegistryImpl();
        this.directiveFactory = new DirectiveFactoryImpl();
        super.activate(context);
    }

    public void registerExtension(Extension extension) throws Exception {
        Object[] contributions;
        for (Object contribution : contributions = extension.getContributions()) {
            this.registerScannerConfiguration((ScannerConfiguration)((Object)contribution));
        }
    }

    private void registerScannerConfiguration(ScannerConfiguration configuration) throws Exception {
        this.schedulerService.registerSchedule((Schedule)configuration);
        this.configRegistry.registerDirectiveParameterization(configuration);
        this.configRegistry.registerUpdaterParameterization(configuration.getEventId(), configuration.getUpdaterParameterization());
    }

    @Override
    public Directive getDirective(Event event) throws DirectiveException {
        Map.Entry<String, Serializable> parameterization = this.configRegistry.getDirectiveParameterization(event.getName());
        DirectiveType type = DirectiveType.valueOf(parameterization.getKey());
        String query = (String)((Object)parameterization.getValue());
        return this.directiveFactory.create(type, query);
    }

    @Override
    public AbstractScanUpdater getUpdater(Event event) throws Exception {
        ScanUpdaterConfiguration updaterCfg = this.configRegistry.getUpdaterParameterization(event.getName());
        AbstractScanUpdater updater = (AbstractScanUpdater)updaterCfg.getUpdaterClass().newInstance();
        updater.setCfgParams(updaterCfg.getParams());
        return updater;
    }
}

