/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.security;

import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.nuxeo.common.utils.ArrayUtils;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;

public class ToutaticeOwnerSecurityPolicy
extends AbstractSecurityPolicy {
    private static final Log log = LogFactory.getLog(ToutaticeOwnerSecurityPolicy.class);
    private static final String[] SIMULATED_DOCUMENT_PERMISSIONS = new String[]{"Read", "Write", "validationWorkflow_validation"};
    private static final String[] SIMULATED_PARENT_PERMISSIONS = new String[]{"Read", "validationWorkflow_validation"};
    private static final String[] NOT_CONDITIONED_SIMULATED_PARENT_PERMISSIONS = new String[]{"Read", "AddChildren", "RemoveChildren"};

    protected String[] getSimulatedDocumentPermissions() {
        return SIMULATED_DOCUMENT_PERMISSIONS;
    }

    protected String[] getSimulatedParentPermissions() {
        return SIMULATED_PARENT_PERMISSIONS;
    }

    protected String[] getNotConditionedParentPermissions() {
        return NOT_CONDITIONED_SIMULATED_PARENT_PERMISSIONS;
    }

    public Access checkPermission(Document doc, ACP mergedAcp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        Access access = Access.UNKNOWN;
        String[] ownerPermissions = (String[])org.apache.commons.lang.ArrayUtils.add((Object[])org.apache.commons.lang.ArrayUtils.EMPTY_STRING_ARRAY, (Object)"WriteModifyOwnOnly");
        try {
            if (this.doPolicyApply(ownerPermissions, mergedAcp, principal, additionalPrincipals)) {
                access = this.applyPolicy(doc, principal, resolvedPermissions);
            }
        }
        catch (DocumentException e) {
            log.error((Object)("Failed to evaluate the policy, error: " + e.getMessage()));
        }
        return access;
    }

    private boolean doPolicyApply(String[] ownerPermissions, ACP mergedAcp, Principal principal, String[] additionalPrincipals) {
        boolean hasEverythingPerm;
        if (!org.apache.commons.lang.ArrayUtils.contains((Object[])additionalPrincipals, (Object)principal.getName())) {
            additionalPrincipals[additionalPrincipals.length] = principal.getName();
        }
        return !(hasEverythingPerm = Access.GRANT.equals(mergedAcp.getAccess(additionalPrincipals, new String[]{"Everything"}))) && Access.GRANT.equals(mergedAcp.getAccess(additionalPrincipals, ownerPermissions));
    }

    protected Access applyPolicy(Document doc, Principal principal, String[] resolvedPermissions) throws DocumentException {
        String[] simulatedPerms = null;
        simulatedPerms = this.isCreator(doc, principal) ? (String[])org.apache.commons.lang.ArrayUtils.addAll((Object[])this.getSimulatedDocumentPermissions(), (Object[])this.getSimulatedParentPermissions()) : this.getNotConditionedParentPermissions();
        Object[] allowedPerms = (String[])ArrayUtils.intersect((Object[][])new String[][]{simulatedPerms, resolvedPermissions});
        if (org.apache.commons.lang.ArrayUtils.isNotEmpty((Object[])allowedPerms)) {
            return Access.GRANT;
        }
        return Access.UNKNOWN;
    }

    protected boolean isCreator(Document doc, Principal principal) throws DocumentException {
        String creator = (String)((Object)doc.getPropertyValue("dc:creator"));
        return StringUtils.equals((String)principal.getName(), (String)creator);
    }

    public boolean isRestrictingPermission(String permission) {
        assert (permission.equals("Browse"));
        return false;
    }

    public boolean isExpressibleInQuery() {
        return true;
    }

    public SQLQuery.Transformer getQueryTransformer() {
        return SQLQuery.Transformer.IDENTITY;
    }
}

