/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.reporter;

import java.util.Map;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ec.notification.email.EmailHelper;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.ecm.reporter.Reporter;
import org.opentoutatice.ecm.reporting.test.mode.ErrorTestMode;
import org.opentoutatice.ecm.reporting.test.mode.ErrorTestModeException;

public abstract class AbstractMailer
implements Reporter {
    public static final Log log = LogFactory.getLog(AbstractMailer.class);
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    public static final String MAIL_TO = "mail.to";
    public static final String SEND_MAIL = "ottc.news.scan.send.mail";
    private Map<String, Object> data;
    private EmailHelper emailHelper = new EmailHelper();

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    @Override
    public void send(Object content) throws MessagingException, ErrorTestModeException {
        if (ErrorTestMode.generateErrorInTry(4)) {
            throw new ErrorTestModeException("Error in Mailer#send");
        }
        try {
            if (Framework.isBooleanPropertyTrue((String)SEND_MAIL)) {
                this.emailHelper.sendmail((Map)content);
                if (log.isInfoEnabled()) {
                    log.info((Object)"         [Mail sent]");
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"         [Mail should have been sent]");
            }
        }
        catch (Exception e) {
            throw new MessagingException("Can not send mail", e);
        }
    }
}

