/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.scanner.directive;

import org.opentoutatice.ecm.scanner.directive.Directive;
import org.opentoutatice.ecm.scanner.directive.DirectiveException;
import org.opentoutatice.ecm.scanner.directive.DirectiveFactory;
import org.opentoutatice.ecm.scanner.directive.DirectiveType;
import org.opentoutatice.ecm.scanner.directive.nxql.AbstractNxqlDirective;
import org.opentoutatice.ecm.scanner.directive.nxql.NxqlQueryAndFetchDirective;
import org.opentoutatice.ecm.scanner.directive.nxql.NxqlQueryDirective;

public class DirectiveFactoryImpl
implements DirectiveFactory {
    @Override
    public Directive create(DirectiveType type) throws DirectiveException {
        AbstractNxqlDirective directive = null;
        switch (type) {
            case nxql: {
                directive = new NxqlQueryDirective();
                break;
            }
            case nxqlQueryAndFetch: {
                directive = new NxqlQueryAndFetchDirective();
                break;
            }
        }
        return directive;
    }

    @Override
    public Directive create(DirectiveType type, String query) throws DirectiveException {
        AbstractNxqlDirective directive = null;
        switch (type) {
            case nxql: {
                directive = new NxqlQueryDirective(query);
                break;
            }
            case nxqlQueryAndFetch: {
                directive = new NxqlQueryAndFetchDirective(query);
                break;
            }
        }
        return directive;
    }
}

