/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.factories;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.platform.content.template.factories.SimpleTemplateBasedFactory;
import org.nuxeo.ecm.platform.content.template.service.TemplateItemDescriptor;

public class SimpleTemplateBasedRootFactory
extends SimpleTemplateBasedFactory {
    @Override
    public void createContentStructure(DocumentModel eventDoc) throws ClientException {
        this.initSession(eventDoc);
        if (!this.shouldCreateContent(eventDoc)) {
            return;
        }
        for (TemplateItemDescriptor item : this.template) {
            String itemPath = eventDoc.getPathAsString();
            if (item.getPath() != null) {
                itemPath = itemPath + "/" + item.getPath();
            }
            DocumentModel newChild = this.session.createDocumentModel(itemPath, item.getId(), item.getTypeName());
            newChild.setProperty("dublincore", "title", (Object)item.getTitle());
            newChild.setProperty("dublincore", "description", (Object)item.getDescription());
            this.setProperties(item.getProperties(), newChild);
            newChild = this.session.createDocument(newChild);
            this.setAcl(item.getAcl(), newChild.getRef());
        }
        this.setAcl(this.acl, eventDoc.getRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldCreateContent(DocumentModel eventDoc) throws ClientException {
        for (TemplateItemDescriptor item : this.template) {
            String query = "SELECT ecm:uuid FROM Document WHERE ecm:parentId = '%s' AND ecm:primaryType = '%s'";
            query = String.format(query, eventDoc.getId(), item.getTypeName());
            try (IterableQueryResult it = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                if (!it.iterator().hasNext()) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }
}

