/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.mail;

import java.io.InputStream;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mailer {
    private static final Log log = LogFactory.getLog(Mailer.class);
    protected Properties config;
    protected volatile Session session;
    protected Authenticator auth;
    protected final String sessionName;

    public Mailer() {
        this(null, new Properties());
    }

    public Mailer(Properties config) {
        this(null, config);
    }

    public Mailer(String sessionName) {
        this(sessionName, new Properties());
    }

    public Mailer(String sessionName, Properties config) {
        this.config = config;
        this.sessionName = sessionName;
        final String user = config.getProperty("mail.smtp.user");
        final String pass = config.getProperty("mail.smtp.password");
        if (user != null && pass != null) {
            this.setAuthenticator(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pass);
                }
            });
        }
    }

    public void setServer(String host) {
        this.setServer(host, "25", false);
    }

    public void setServer(String host, boolean ssl) {
        this.setServer(host, ssl ? "465" : "25", ssl);
    }

    public void setServer(String host, String port) {
        this.setServer(host, port, false);
    }

    public void setServer(String host, String port, boolean ssl) {
        if (ssl) {
            if (port == null) {
                port = "465";
            }
            this.config.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            this.config.put("mail.smtp.socketFactory.fallback", "false");
            this.config.put("mail.smtp.socketFactory.port", port);
        } else if (port == null) {
            port = "25";
        }
        this.config.setProperty("mail.smtp.host", host);
        this.config.setProperty("mail.smtp.port", port);
        this.session = null;
    }

    public void setCredentials(final String user, final String pass) {
        this.config.setProperty("mail.smtp.auth", "true");
        this.auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, pass);
            }
        };
        this.session = null;
    }

    public void setAuthenticator(Authenticator auth) {
        this.config.setProperty("mail.smtp.auth", "true");
        this.auth = auth;
        this.session = null;
    }

    public void setDebug(boolean debug) {
        this.config.setProperty("mail.debug", Boolean.toString(debug));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession() {
        if (this.session == null) {
            Mailer mailer = this;
            synchronized (mailer) {
                if (this.session == null) {
                    if (this.sessionName != null) {
                        try {
                            InitialContext ic = new InitialContext();
                            this.session = (Session)ic.lookup(this.sessionName);
                        }
                        catch (NamingException e) {
                            log.warn((Object)("Failed to lookup mail session using JNDI name " + this.sessionName + ". Falling back on local configuration."));
                            this.session = Session.getInstance((Properties)this.config, (Authenticator)this.auth);
                        }
                    } else {
                        this.session = Session.getInstance((Properties)this.config, (Authenticator)this.auth);
                    }
                }
            }
        }
        return this.session;
    }

    public Properties getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Properties config) {
        this.config = config;
    }

    public void loadConfiguration(InputStream in) throws Exception {
        this.config.load(in);
    }

    public void send(MimeMessage message) throws MessagingException {
        Transport.send((javax.mail.Message)message);
    }

    public Message newMessage() {
        return new Message(this.getSession());
    }

    public void sendEmail(String from, String to, String subject, String body) throws MessagingException {
        MimeMessage message = new MimeMessage(this.getSession());
        message.setFrom((Address)new InternetAddress(from));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        message.setSubject(subject);
        message.setText(body);
        Transport.send((javax.mail.Message)message);
    }

    public static class Message
    extends MimeMessage {
        public Message(Session session) {
            super(session);
        }

        public Message(Session session, InputStream in) throws MessagingException {
            super(session, in);
        }

        public Message addTo(String to) throws MessagingException {
            this.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            return this;
        }

        public Message addCc(String cc) throws MessagingException {
            this.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
            return this;
        }

        public Message addBcc(String bcc) throws MessagingException {
            this.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
            return this;
        }

        public Message addFrom(String from) throws MessagingException {
            this.addFrom((Address[])new InternetAddress[]{new InternetAddress(from)});
            return this;
        }

        public void addInfoInMessageHeader(String address, AS as) throws MessagingException {
            switch (as) {
                case FROM: {
                    this.addFrom(address);
                    break;
                }
                case TO: {
                    this.addTo(address);
                    break;
                }
                case CC: {
                    this.addCc(address);
                    break;
                }
                case BCC: {
                    this.addBcc(address);
                    break;
                }
                case REPLYTO: {
                    Address[] oldValue = this.getReplyTo();
                    Address[] replyToValue = this.getReplyTo() == null ? new Address[1] : new Address[oldValue.length + 1];
                    for (int i = 0; i < oldValue.length; ++i) {
                        replyToValue[i] = oldValue[i];
                    }
                    replyToValue[oldValue.length] = new InternetAddress(address);
                    this.setReplyTo(replyToValue);
                    break;
                }
                default: {
                    throw new MessagingException("Unknown header info " + as.toString());
                }
            }
        }

        public Message setFrom(String from) throws MessagingException {
            this.setFrom((Address)new InternetAddress(from));
            return this;
        }

        public void send() throws MessagingException {
            Transport.send((javax.mail.Message)this);
        }

        public static enum AS {
            FROM,
            TO,
            CC,
            BCC,
            REPLYTO;

        }
    }
}

