/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.rendering;

import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import org.nuxeo.ecm.automation.core.rendering.Renderer;
import org.nuxeo.ecm.platform.rendering.api.ResourceLocator;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.resource.ResourceService;

public class FreemarkerRender
extends FreemarkerEngine
implements Renderer {
    public FreemarkerRender() {
        this.setResourceLocator(new ResourceLocator(){

            public URL getResourceURL(String key) {
                try {
                    if (key.startsWith("template:")) {
                        return ((ResourceService)Framework.getService(ResourceService.class)).getResource(key.substring("template:".length()));
                    }
                    return new URL(key);
                }
                catch (Exception e) {
                    return null;
                }
            }

            public File getResourceFile(String key) {
                return null;
            }
        });
    }

    public void renderContent(String content, Object ctx, Writer writer) throws Exception {
        StringReader reader = new StringReader(content);
        Template tpl = new Template("@inline", (Reader)reader, this.getConfiguration(), "UTF-8");
        Environment env = tpl.createProcessingEnvironment(ctx, writer, (ObjectWrapper)this.getObjectWrapper());
        env.process();
    }

    @Override
    public String render(String uriOrContent, Map<String, Object> root) throws Exception {
        if (root.get("Document") != null) {
            root.put("Document", root.get("This"));
        }
        StringWriter result = new StringWriter();
        if (uriOrContent.startsWith("template:")) {
            this.render(uriOrContent, root, result);
        } else {
            this.renderContent(uriOrContent, root, result);
        }
        return result.getBuffer().toString();
    }
}

