/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.workflows.integration.beans;

import fr.toutatice.ecm.platform.service.portalviews.adapter.WidgetsAdapterService;
import fr.toutatice.ecm.platform.web.workflows.ToutaticeRoutingTaskActionsBean;
import fr.toutatice.ecm.workflows.integration.constants.WorkflowsConstants;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="routingTaskActions")
@Install(precedence=42)
public class IntegrationRoutingTaskActionsBean
extends ToutaticeRoutingTaskActionsBean {
    private static final long serialVersionUID = -4786832650539519266L;

    public String endTask(Task task) throws ClientException {
        String view = "view_documents";
        String currentWfName = this.getCurrentWorkflowName(task);
        if (WorkflowsConstants.VALIDATION_WORKFLOWS.contains(currentWfName)) {
            String clickedButton = this.getClickedButton();
            WidgetsAdapterService aSrv = (WidgetsAdapterService)Framework.getService(WidgetsAdapterService.class);
            if (aSrv.isInPortalViewContext()) {
                if (WorkflowsConstants.CONTINUE_VALIDATION_ACTIONS.contains(clickedButton)) {
                    view = "current_task";
                } else if (WorkflowsConstants.ENDED_VALIDATION_ACTIONS.contains(clickedButton)) {
                    view = "action_done";
                }
            }
            super.endTask(task);
        } else {
            view = super.endTask(task);
        }
        return view;
    }

    public String getCurrentWorkflowName(Task task) {
        DocumentModel documentRouteModel = this.getCurrentWfModel(task);
        return documentRouteModel.getTitle();
    }

    public DocumentModel getCurrentWfModel(Task task) {
        String routeInstanceDocId = task.getVariable("routeInstanceDocId");
        return this.documentManager.getDocument((DocumentRef)new IdRef(routeInstanceDocId));
    }
}

