/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.fm.adapters;

import freemarker.core.CollectionAndSequence;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.io.Serializable;
import java.util.ArrayList;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.rendering.fm.adapters.DocumentObjectWrapper;
import org.nuxeo.ecm.platform.rendering.fm.adapters.PropertyWrapper;

public class ComplexPropertyTemplate
extends PropertyWrapper
implements TemplateHashModelEx,
AdapterTemplateModel {
    protected final Property property;

    public ComplexPropertyTemplate(DocumentObjectWrapper wrapper, Property property) {
        super(wrapper);
        this.property = property;
    }

    public Object getAdaptedObject(Class hint) {
        return this.property;
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        ArrayList<String> list = new ArrayList<String>(this.property.size());
        for (Property p : this.property.getChildren()) {
            list.add(p.getName());
        }
        return new CollectionAndSequence((TemplateSequenceModel)new SimpleSequence(list, (ObjectWrapper)this.wrapper));
    }

    public int size() throws TemplateModelException {
        return this.property.size();
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        try {
            ArrayList<Object> list = new ArrayList<Object>(this.property.size());
            for (Property p : this.property.getChildren()) {
                Serializable value = p.getValue();
                list.add(value == null ? "" : value);
            }
            return new CollectionAndSequence((TemplateSequenceModel)new SimpleSequence(list, (ObjectWrapper)this.wrapper));
        }
        catch (PropertyException e) {
            throw new TemplateModelException("Failed to adapt complex property values", (Exception)((Object)e));
        }
    }

    public TemplateModel get(String name) throws TemplateModelException {
        try {
            Property p = this.property.get(name);
            return this.wrap(p);
        }
        catch (PropertyException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
    }

    public boolean isEmpty() throws TemplateModelException {
        return this.property.size() == 0;
    }
}

