/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm.internal;

import com.sun.jdmk.NotificationRegistration;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatNotification;
import com.sun.jdmk.comm.HttpConnectorAddress;
import com.sun.jdmk.comm.HttpConnectorClient;
import com.sun.jdmk.comm.HttpsConnectorClient;
import com.sun.jdmk.comm.JdmkLegacyConnector;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorClient;
import com.sun.jdmk.comm.internal.EnvHelp;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public class JDMKClientConnector
implements JMXConnector,
JdmkLegacyConnector {
    private MBeanServerConnectionImpl serverConnection;
    private final RemoteMBeanServer mserver;
    private final NotificationRegistration nregistry;
    private Map env;
    private JMXServiceURL address;
    private String connectionId = null;
    private static int idCounter = 0;
    private boolean connected = false;
    private boolean terminated = false;
    private final int[] lock = new int[0];
    private final NotificationBroadcasterSupport connectionBroadcaster = new NotificationBroadcasterSupport();
    private final HeartBeatNotifListener myListener = new HeartBeatNotifListener();
    private ClassLogger logger;

    public JDMKClientConnector(JMXServiceURL serviceURL, Map env) throws IOException {
        if (serviceURL == null) {
            throw new IllegalArgumentException("Null url.");
        }
        this.env = env == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(env);
        this.address = serviceURL;
        String protocol = this.address.getProtocol();
        this.logger = new ClassLogger("com.sun.jdmk.comm.legacy.client.wrapper", "JDMKClientConnector-" + protocol);
        if (this.logger.fineOn()) {
            this.logger.fine("Constructor", "Construct a JDMK legacy connector wrapper: " + this.address);
        }
        String local = null;
        try {
            local = (String)this.env.get("com.sun.jdmk.client.localhost");
        }
        catch (ClassCastException e) {
            IOException ioe = new IOException(e.toString());
            EnvHelp.initCause(ioe, e);
            throw ioe;
        }
        if ("jdmk-rmi".equals(protocol)) {
            RmiConnectorClient client = new RmiConnectorClient(local);
            this.mserver = client;
            this.nregistry = client;
            return;
        }
        if ("jdmk-http".equals(protocol)) {
            HttpConnectorClient client = new HttpConnectorClient(local);
            this.mserver = client;
            this.nregistry = client;
        } else if ("jdmk-https".equals(protocol)) {
            boolean needClientAuth = true;
            String needClientAuthStr = (String)env.get("com.sun.jdmk.https.server.need.client.auth");
            if (needClientAuthStr != null && "false".equals(needClientAuthStr.toLowerCase())) {
                needClientAuth = false;
            }
            HttpsConnectorClient client = new HttpsConnectorClient(local, needClientAuth);
            this.mserver = client;
            this.nregistry = client;
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + protocol);
        }
    }

    @Override
    public void connect() throws IOException {
        this.connect((Map)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map env) throws IOException {
        if (this.logger.fineOn()) {
            this.logger.fine("connect", "Connecting the client to " + this.address);
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.terminated) {
                throw new IOException("The client has been closed.");
            }
            if (this.connected) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            HashMap tmpEnv = new HashMap(this.env);
            if (env != null) {
                EnvHelp.checkAttributes(env);
                tmpEnv.putAll(env);
            }
            ConnectorAddress addr = null;
            if ("jdmk-rmi".equals(this.address.getProtocol())) {
                String sn = this.address.getURLPath();
                int i = sn.indexOf("/");
                if (i < 0 || sn.length() == i + 1) {
                    sn = "name=RmiConnectorServer";
                } else if ((sn = sn.substring(i + 1)).trim().equals("")) {
                    sn = "name=RmiConnectorServer";
                }
                addr = new RmiConnectorAddress(this.address.getHost(), this.address.getPort(), sn);
            } else {
                AuthInfo ai = null;
                try {
                    ai = (AuthInfo)tmpEnv.get("com.sun.jdmk.http.client.authinfo");
                }
                catch (ClassCastException e) {
                    IOException ioe = new IOException(e.toString());
                    EnvHelp.initCause(ioe, e);
                    throw ioe;
                }
                addr = ai == null ? new HttpConnectorAddress(this.address.getHost(), this.address.getPort()) : new HttpConnectorAddress(this.address.getHost(), this.address.getPort(), ai);
            }
            this.connectionId = String.valueOf(this.address.getProtocol()) + "://" + InetAddress.getLocalHost().getHostName() + ":" + this.address.getPort() + "  " + idCounter++;
            ((HeartBeatClientHandler)((Object)this.mserver)).addHeartBeatNotificationListener(this.myListener, null, null);
            try {
                this.mserver.connect(addr);
            }
            catch (CommunicationException ce) {
                throw this.wrapToIO(ce);
            }
            if (this.logger.fineOn()) {
                this.logger.fine("connect", "The client has been connected with the ID " + this.connectionId);
            }
            this.serverConnection = new MBeanServerConnectionImpl();
            this.env = tmpEnv;
            this.connected = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.logger.fineOn()) {
            this.logger.fine("close", "The client " + this.connectionId + " is asked to be closed.");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.terminated) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.terminated = true;
            this.connected = false;
            this.mserver.disconnect();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getConnectionId() throws IOException {
        return this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (!this.connected) {
                throw new IOException("Not connected.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.serverConnection;
        }
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        if (delegationSubject == null) {
            return this.getMBeanServerConnection();
        }
        throw new UnsupportedOperationException("Sorry.");
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.connectionBroadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.connectionBroadcaster.removeNotificationListener(listener);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.connectionBroadcaster.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public Object getWrapped() {
        return this.mserver;
    }

    private IOException wrapToIO(CommunicationException ce) {
        IOException ioe = new IOException(ce.toString());
        if (ce.getTargetException() != null) {
            EnvHelp.initCause(ioe, ce.getTargetException());
        } else {
            EnvHelp.initCause(ioe, ce);
        }
        return ioe;
    }

    private class HeartBeatNotifListener
    implements NotificationListener {
        private long sequenceCounter = 0L;

        private HeartBeatNotifListener() {
        }

        @Override
        public void handleNotification(Notification notif, Object hd) {
            HeartBeatNotification hbn = (HeartBeatNotification)notif;
            if ("jdmk.connector.heartbeat.connection.established".equals(hbn.getType())) {
                JMXConnectionNotification jn = new JMXConnectionNotification("jmx.remote.connection.opened", this, JDMKClientConnector.this.connectionId, this.nextSequenceNumber(), "The client has been connected.", null);
                JDMKClientConnector.this.connectionBroadcaster.sendNotification(jn);
            } else if ("jdmk.connector.heartbeat.connection.lost".equals(hbn.getType())) {
                JMXConnectionNotification jn = new JMXConnectionNotification("jmx.remote.connection.failed", this, JDMKClientConnector.this.connectionId, this.nextSequenceNumber(), "The connection to the server is lost.", null);
                JDMKClientConnector.this.connectionBroadcaster.sendNotification(jn);
            } else if ("jdmk.connector.heartbeat.connection.reestablished".equals(hbn.getType())) {
                JMXConnectionNotification jn = new JMXConnectionNotification("jmx.remote.connection.opened", this, JDMKClientConnector.this.connectionId, this.nextSequenceNumber(), "The client has been connected.", null);
                JDMKClientConnector.this.connectionBroadcaster.sendNotification(jn);
            } else if (!"jdmk.connector.heartbeat.connection.retrying".equals(hbn.getType()) && "jdmk.connector.heartbeat.connection.terminated".equals(hbn.getType())) {
                JMXConnectionNotification jn = new JMXConnectionNotification("jmx.remote.connection.closed", this, JDMKClientConnector.this.connectionId, this.nextSequenceNumber(), "The client has been connected.", null);
                JDMKClientConnector.this.connectionBroadcaster.sendNotification(jn);
                if (JDMKClientConnector.this.terminated) {
                    try {
                        JDMKClientConnector.this.connectionBroadcaster.removeNotificationListener(JDMKClientConnector.this.myListener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private synchronized long nextSequenceNumber() {
            return this.sequenceCounter++;
        }
    }

    private class MBeanServerConnectionImpl
    implements MBeanServerConnection {
        private MBeanServerConnectionImpl() {
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            try {
                return JDMKClientConnector.this.mserver.createMBean(className, name);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            try {
                return JDMKClientConnector.this.mserver.createMBean(className, name, loaderName);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            try {
                return JDMKClientConnector.this.mserver.createMBean(className, name, params, signature);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            try {
                return JDMKClientConnector.this.mserver.createMBean(className, name, loaderName, params, signature);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            try {
                JDMKClientConnector.this.mserver.unregisterMBean(name);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
            try {
                return JDMKClientConnector.this.mserver.getObjectInstance(name);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        public Set queryMBeans(ObjectName name, QueryExp query) throws IOException {
            try {
                return JDMKClientConnector.this.mserver.queryMBeans(name, query);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        public Set queryNames(ObjectName name, QueryExp query) throws IOException {
            try {
                return JDMKClientConnector.this.mserver.queryNames(name, query);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public boolean isRegistered(ObjectName name) throws IOException {
            try {
                return JDMKClientConnector.this.mserver.isRegistered(name);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public Integer getMBeanCount() throws IOException {
            try {
                return JDMKClientConnector.this.mserver.getMBeanCount();
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            try {
                return JDMKClientConnector.this.mserver.getAttribute(name, attribute);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            try {
                return JDMKClientConnector.this.mserver.getAttributes(name, attributes);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            try {
                JDMKClientConnector.this.mserver.setAttribute(name, attribute);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            try {
                return JDMKClientConnector.this.mserver.setAttributes(name, attributes);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            try {
                return JDMKClientConnector.this.mserver.invoke(name, operationName, params, signature);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public String getDefaultDomain() throws IOException {
            try {
                return JDMKClientConnector.this.mserver.getDefaultDomain();
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public String[] getDomains() throws IOException {
            Set ns = JDMKClientConnector.this.mserver.queryNames(null, null);
            HashSet<String> list = new HashSet<String>();
            Iterator iter = ns.iterator();
            while (iter.hasNext()) {
                String d = ((ObjectName)iter.next()).getDomain();
                list.add(d);
            }
            try {
                return list.toArray(new String[list.size()]);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            try {
                JDMKClientConnector.this.nregistry.addNotificationListener(name, listener, filter, handback);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            try {
                throw new UnsupportedOperationException("Sorry.");
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            throw new UnsupportedOperationException("Sorry.");
        }

        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            throw new UnsupportedOperationException("Sorry.");
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            try {
                JDMKClientConnector.this.nregistry.removeNotificationListener(name, listener);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            throw new UnsupportedOperationException("Sorry.");
        }

        @Override
        public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            try {
                return JDMKClientConnector.this.mserver.getMBeanInfo(name);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }

        @Override
        public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
            try {
                return JDMKClientConnector.this.mserver.isInstanceOf(name, className);
            }
            catch (CommunicationException ce) {
                throw JDMKClientConnector.this.wrapToIO(ce);
            }
        }
    }
}

