/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.ajax4jsf.model.DataComponentState;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceDataModel;
import org.ajax4jsf.model.SequenceRange;
import org.ajax4jsf.model.SequenceState;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.component.SequenceIterationStatus;
import org.richfaces.component.UIDataAdaptor;
import org.richfaces.model.CollectionDataModel;

public class UISequence
extends UIDataAdaptor {
    private Object iterationStatusVarObject;
    private Converter defaultRowKeyConverter;

    protected void updateState(SequenceState state) {
        state.setFirst(this.getActualFirst());
        state.setRows(this.getActualRows());
    }

    protected void updateState() {
        DataComponentState localState = this.getLocalComponentState();
        if (localState instanceof SequenceState) {
            this.updateState((SequenceState)localState);
        }
    }

    protected int getActualFirst() {
        return this.getFirst();
    }

    protected int getActualRows() {
        return this.getRows();
    }

    protected DataModel<?> createFacesModel(Object value) {
        Object model = null;
        model = value == null ? new ListDataModel(Collections.EMPTY_LIST) : (value instanceof DataModel ? (DataModel)value : (value instanceof List ? new ListDataModel((List)value) : (Object[].class.isAssignableFrom(value.getClass()) ? new ArrayDataModel((Object[])value) : (value instanceof ResultSet ? new ResultSetDataModel((ResultSet)value) : (value instanceof Result ? new ResultDataModel((Result)value) : (value instanceof Collection ? new CollectionDataModel((Collection)value) : new ScalarDataModel(value)))))));
        return model;
    }

    @Override
    protected ExtendedDataModel<?> createExtendedDataModel() {
        Object model = null;
        Object value = this.getValue();
        model = value instanceof ExtendedDataModel ? (ExtendedDataModel)value : new SequenceDataModel(this.createFacesModel(value));
        return model;
    }

    @Override
    protected DataComponentState createComponentState() {
        SequenceState state = new SequenceState();
        this.updateState(state);
        return state;
    }

    @Override
    @Attribute
    public Converter getRowKeyConverter() {
        Converter converter = super.getRowKeyConverter();
        if (converter == null) {
            if (this.defaultRowKeyConverter == null) {
                this.defaultRowKeyConverter = this.getFacesContext().getApplication().createConverter(Integer.class);
            }
            converter = this.defaultRowKeyConverter;
        }
        return converter;
    }

    @Attribute
    public int getFirst() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.first), (Object)0);
    }

    public void setFirst(int first) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.first), (Object)first);
        this.updateState();
    }

    @Attribute
    public int getRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rows), (Object)0);
    }

    public void setRows(int rows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rows), (Object)rows);
        this.updateState();
    }

    @Attribute
    public Object getValue() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value));
    }

    public void setValue(Object value) {
        this.resetDataModel();
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), value);
    }

    @Attribute
    public String getIterationStatusVar() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.iterationStatusVar));
    }

    public void setIterationStatusVar(String iterationStatusVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.iterationStatusVar), (Object)iterationStatusVar);
    }

    public int getRowIndex() {
        return this.getExtendedDataModel().getRowIndex();
    }

    @Override
    public void captureOrigValue(FacesContext faces) {
        super.captureOrigValue(faces);
        String iterationStatusVar = this.getIterationStatusVar();
        if (iterationStatusVar != null) {
            Map<String, Object> variablesMap = this.getVariablesMap(faces);
            this.iterationStatusVarObject = variablesMap.get(iterationStatusVar);
        }
    }

    @Override
    public void restoreOrigValue(FacesContext faces) {
        super.restoreOrigValue(faces);
        String iterationStatusVar = this.getIterationStatusVar();
        if (iterationStatusVar != null) {
            Map<String, Object> variablesMap = this.getVariablesMap(faces);
            if (this.iterationStatusVarObject != null) {
                variablesMap.put(iterationStatusVar, this.iterationStatusVarObject);
            } else {
                variablesMap.remove(iterationStatusVar);
            }
        }
    }

    @Override
    protected void setupVariable(FacesContext faces, boolean rowSelected) {
        super.setupVariable(faces, rowSelected);
        String iterationStatusVar = this.getIterationStatusVar();
        if (iterationStatusVar != null) {
            Map<String, Object> requestMap = this.getVariablesMap(faces);
            if (rowSelected) {
                Integer begin = null;
                Integer end = null;
                Range range = this.getComponentState().getRange();
                if (range instanceof SequenceRange) {
                    SequenceRange sequenceRange = (SequenceRange)range;
                    begin = sequenceRange.getFirstRow();
                    int iRows = sequenceRange.getRows();
                    if (iRows > 0) {
                        end = begin + iRows - 1;
                    }
                }
                SequenceIterationStatus iterationStatus = new SequenceIterationStatus(begin, end, this.getRowIndex(), this.getRowCount());
                requestMap.put(iterationStatusVar, iterationStatus);
            } else {
                requestMap.remove(iterationStatusVar);
            }
        }
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if ("value".equals(name)) {
            this.resetDataModel();
        } else if ("first".equals(name) || "rows".equals(name)) {
            this.updateState();
        }
        super.setValueBinding(name, binding);
    }

    @Override
    public void setValueExpression(String name, ValueExpression binding) {
        if ("value".equals(name)) {
            this.resetDataModel();
        } else if ("first".equals(name) || "rows".equals(name)) {
            this.updateState();
        }
        super.setValueExpression(name, binding);
    }

    @Override
    protected void preEncodeBegin(FacesContext context) {
        super.preEncodeBegin(context);
        this.updateState();
    }

    public int getRelativeRowIndex() {
        int rowIndex = this.getRowIndex();
        int rows = this.getRows();
        if (rows > 1) {
            return rowIndex % rows;
        }
        return rowIndex;
    }

    public String getRelativeClientId(FacesContext facesContext) {
        Object savedRowKey = this.getRowKey();
        this.setRowKey(null);
        StringBuilder baseId = new StringBuilder(this.getClientId(facesContext));
        this.setRowKey(savedRowKey);
        String result = baseId.append(UINamingContainer.getSeparatorChar((FacesContext)facesContext)).append(this.getRelativeRowIndex()).toString();
        return result;
    }

    protected static enum PropertyKeys {
        first,
        rows,
        value,
        iterationStatusVar;

    }
}

