/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.user.center.profile.UserProfileService;

@Operation(id="Services.GetToutaticeUserProfile", category="Services", label="Get UserProfile", since="5.6.0", description="Get the user profile document of the connected user (may create it and the user worksapce if one doesn't exist")
public class GetUserProfile {
    public static final String ID = "Services.GetToutaticeUserProfile";
    private static final Log log = LogFactory.getLog(GetUserProfile.class);
    @Param(name="username", required=false)
    protected String username;
    @Context
    protected OperationContext ctx;
    @Context
    protected UserProfileService userProfileService;

    @OperationMethod
    public Object run() throws Exception {
        DocumentModel userProfile = null;
        NuxeoPrincipal principal = (NuxeoPrincipal)this.ctx.getPrincipal();
        try {
            userProfile = StringUtils.isNotBlank((String)this.username) ? this.userProfileService.getUserProfileDocument(this.username, this.ctx.getCoreSession()) : this.userProfileService.getUserProfileDocument(this.ctx.getCoreSession());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return userProfile;
    }
}

