/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.document;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;

@Operation(id="FileManager.ImportZip", category="Services", label="Create a Document hiearchy from a zipfile", description="Create a Document hiearchy from a zipfile")
public class ImportZipDocument {
    public static final String ID = "FileManager.ImportZip";
    @Context
    protected AutomationService as;
    @Context
    protected OperationContext context;
    @Context
    protected FileManager fileManager;

    protected DocumentModel getCurrentDocument() throws Exception {
        String cdRef = (String)this.context.get((Object)"currentDocument");
        return (DocumentModel)this.as.getAdaptedValue(this.context, (Object)cdRef, DocumentModel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public void run(Blob blob) throws Exception {
        DocumentModel currentDocument = this.getCurrentDocument();
        int indexOfIgnoreCase = StringUtils.indexOfIgnoreCase((String)blob.getFilename(), (String)".zip");
        String zipRootFolderName = blob.getFilename().substring(0, indexOfIgnoreCase);
        DocumentModel zipRootFolder = this.fileManager.createFolder(this.context.getCoreSession(), zipRootFolderName, currentDocument.getPathAsString(), true);
        File tmp = null;
        try {
            CharsetDetector detector = new CharsetDetector();
            detector.setText(blob.getStream());
            CharsetMatch charsetMatch = detector.detect();
            tmp = File.createTempFile("importer", null);
            blob.transferTo(tmp);
            ZipFile zipFile = new ZipFile(tmp, charsetMatch.getName());
            Enumeration enu = zipFile.getEntries();
            while (enu.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)enu.nextElement();
                String name = zipEntry.getName();
                DocumentModel documentFolder = zipRootFolder;
                String entryFileName = name;
                if (name.endsWith("/")) {
                    this.createFolder(name, zipRootFolder);
                    continue;
                }
                entryFileName = name;
                if (name.contains("/")) {
                    entryFileName = StringUtils.substringAfterLast((String)name, (String)"/");
                    String entryDirName = StringUtils.substringBeforeLast((String)name, (String)"/");
                    documentFolder = this.createFolder(entryDirName, zipRootFolder);
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                InputStreamBlob input = new InputStreamBlob(inputStream);
                this.fileManager.createDocumentFromBlob(this.context.getCoreSession(), (Blob)input, documentFolder.getPathAsString(), true, entryFileName);
            }
            zipFile.close();
        }
        finally {
            tmp.delete();
        }
    }

    private DocumentModel createFolder(String zipPath, DocumentModel documentFolder) throws Exception {
        for (String dir : zipPath.split("/")) {
            DocumentModel existingDocByTitle = FileManagerUtils.getExistingDocByTitle((CoreSession)this.context.getCoreSession(), (String)documentFolder.getPathAsString(), (String)dir);
            documentFolder = existingDocByTitle == null ? this.fileManager.createFolder(this.context.getCoreSession(), dir, documentFolder.getPathAsString(), true) : existingDocByTitle;
        }
        return documentFolder;
    }
}

