/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.security;

import fr.toutatice.ecm.platform.automation.security.ACEsOperationHelper;
import fr.toutatice.ecm.platform.automation.security.AbstractACEsOperation;
import java.util.List;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;

@Operation(id="Document.AddACEs")
public class AddACEs
extends AbstractACEsOperation {
    public static final String ID = "Document.AddACEs";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Param(name="acl", required=false, values={"inherited", "local"})
    protected String aclName = "local";
    @Param(name="aces", required=false)
    protected Properties aces;
    @Param(name="blockInheritance", required=false)
    protected boolean blockInheritance = false;

    @OperationMethod
    public DocumentModel run(DocumentModel document) throws Exception {
        return super.execute(this.ctx, this.session, document, this.aclName, this.aces, this.blockInheritance);
    }

    @Override
    protected ACL modifyACEs(ACL acl, List<ACE> aces) {
        ACE blockInhACe = ACEsOperationHelper.getBlockInheritanceACe();
        int blockInhPos = acl.indexOf((Object)blockInhACe);
        for (ACE aceToAdd : aces) {
            if (acl.contains((Object)aceToAdd)) continue;
            if (blockInhPos != -1) {
                acl.add(blockInhPos, (Object)aceToAdd);
                continue;
            }
            acl.add((Object)aceToAdd);
        }
        return acl;
    }
}

