/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.Video;
import org.nuxeo.ecm.platform.video.VideoConversionStatus;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.ecm.platform.video.service.AutomaticVideoConversion;
import org.nuxeo.ecm.platform.video.service.AutomaticVideoConversionContributionHandler;
import org.nuxeo.ecm.platform.video.service.VideoConversion;
import org.nuxeo.ecm.platform.video.service.VideoConversionContributionHandler;
import org.nuxeo.ecm.platform.video.service.VideoConversionId;
import org.nuxeo.ecm.platform.video.service.VideoConversionWork;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class VideoServiceImpl
extends DefaultComponent
implements VideoService {
    protected static final Log log = LogFactory.getLog(VideoServiceImpl.class);
    public static final String VIDEO_CONVERSIONS_EP = "videoConversions";
    public static final String DEFAULT_VIDEO_CONVERSIONS_EP = "automaticVideoConversions";
    protected VideoConversionContributionHandler videoConversions;
    protected AutomaticVideoConversionContributionHandler automaticVideoConversions;

    public void activate(ComponentContext context) throws Exception {
        this.videoConversions = new VideoConversionContributionHandler();
        this.automaticVideoConversions = new AutomaticVideoConversionContributionHandler();
    }

    public void deactivate(ComponentContext context) throws Exception {
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        if (workManager != null && workManager.isStarted()) {
            workManager.shutdownQueue(workManager.getCategoryQueueId("videoConversion"), 10L, TimeUnit.SECONDS);
        }
        this.videoConversions = null;
        this.automaticVideoConversions = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (VIDEO_CONVERSIONS_EP.equals(extensionPoint)) {
            this.videoConversions.addContribution((VideoConversion)contribution);
        } else if (DEFAULT_VIDEO_CONVERSIONS_EP.equals(extensionPoint)) {
            this.automaticVideoConversions.addContribution((AutomaticVideoConversion)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (VIDEO_CONVERSIONS_EP.equals(extensionPoint)) {
            this.videoConversions.removeContribution((VideoConversion)contribution);
        } else if (DEFAULT_VIDEO_CONVERSIONS_EP.equals(extensionPoint)) {
            this.automaticVideoConversions.removeContribution((AutomaticVideoConversion)contribution);
        }
    }

    public Collection<VideoConversion> getAvailableVideoConversions() {
        return this.videoConversions.registry.values();
    }

    public void launchConversion(DocumentModel doc, String conversionName) {
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        if (workManager == null) {
            throw new RuntimeException("No WorkManager available");
        }
        VideoConversionWork work = new VideoConversionWork(doc.getRepositoryName(), doc.getId(), conversionName);
        workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_RUNNING_OR_SCHEDULED);
    }

    public void launchAutomaticConversions(DocumentModel doc) {
        ArrayList<AutomaticVideoConversion> conversions = new ArrayList<AutomaticVideoConversion>(this.automaticVideoConversions.registry.values());
        Collections.sort(conversions);
        for (AutomaticVideoConversion conversion : conversions) {
            this.launchConversion(doc, conversion.getName());
        }
    }

    @Deprecated
    public TranscodedVideo convert(VideoConversionId id, Video originalVideo, String conversionName) {
        return this.convert(originalVideo, conversionName);
    }

    public TranscodedVideo convert(Video originalVideo, String conversionName) {
        try {
            if (!this.videoConversions.registry.containsKey(conversionName)) {
                throw new ClientRuntimeException(String.format("'%s' is not a registered video conversion.", conversionName));
            }
            SimpleBlobHolder blobHolder = new SimpleBlobHolder(originalVideo.getBlob());
            VideoConversion conversion = this.videoConversions.registry.get(conversionName);
            HashMap<String, Long> parameters = new HashMap<String, Long>();
            parameters.put("height", conversion.getHeight());
            parameters.put("videoInfo", (Long)originalVideo.getVideoInfo());
            ConversionService conversionService = (ConversionService)Framework.getLocalService(ConversionService.class);
            BlobHolder result = conversionService.convert(conversion.getConverter(), (BlobHolder)blobHolder, parameters);
            VideoInfo videoInfo = VideoHelper.getVideoInfo(result.getBlob());
            return TranscodedVideo.fromBlobAndInfo((String)conversionName, (Blob)result.getBlob(), (VideoInfo)videoInfo);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Deprecated
    public VideoConversionStatus getProgressStatus(VideoConversionId id) {
        DocumentLocation loc = id.getDocumentLocation();
        return this.getProgressStatus(loc.getServerName(), loc.getIdRef().value, id.getConversionName());
    }

    public VideoConversionStatus getProgressStatus(String repositoryName, String docId, String conversionName) {
        VideoConversionWork work;
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        Work.State state = workManager.getWorkState((work = new VideoConversionWork(repositoryName, docId, conversionName)).getId());
        if (state == null || state == Work.State.COMPLETED) {
            return null;
        }
        if (state == Work.State.SCHEDULED) {
            String queueId = workManager.getCategoryQueueId("videoConversion");
            int queueSize = workManager.getQueueSize(queueId, Work.State.SCHEDULED);
            return new VideoConversionStatus("status.video.conversionQueued", 0, queueSize);
        }
        return new VideoConversionStatus("status.video.conversionPending", 0, 0);
    }
}

