/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.List;
import net.bull.javamelody.PID;

class ThreadInformations
implements Serializable {
    private static final long serialVersionUID = 3604281253550723654L;
    private static final ThreadMXBean THREAD_BEAN = ManagementFactory.getThreadMXBean();
    private static final boolean CPU_TIME_ENABLED = THREAD_BEAN.isThreadCpuTimeSupported() && THREAD_BEAN.isThreadCpuTimeEnabled();
    private final String name;
    private final long id;
    private final int priority;
    private final boolean daemon;
    private final Thread.State state;
    private final long cpuTimeMillis;
    private final long userTimeMillis;
    private final boolean deadlocked;
    private final String globalThreadId;
    private final List<StackTraceElement> stackTrace;

    ThreadInformations(Thread thread, List<StackTraceElement> stackTrace, long cpuTimeMillis, long userTimeMillis, boolean deadlocked, String hostAddress) {
        assert (thread != null);
        assert (stackTrace == null || stackTrace instanceof Serializable);
        this.name = thread.getName();
        this.id = thread.getId();
        this.priority = thread.getPriority();
        this.daemon = thread.isDaemon();
        this.state = thread.getState();
        this.stackTrace = stackTrace;
        this.cpuTimeMillis = cpuTimeMillis;
        this.userTimeMillis = userTimeMillis;
        this.deadlocked = deadlocked;
        this.globalThreadId = ThreadInformations.buildGlobalThreadId(thread, hostAddress);
    }

    static long getCurrentThreadCpuTime() {
        return ThreadInformations.getThreadCpuTime(Thread.currentThread().getId());
    }

    static long getThreadCpuTime(long threadId) {
        if (CPU_TIME_ENABLED) {
            return THREAD_BEAN.getThreadCpuTime(threadId);
        }
        return 0L;
    }

    String getName() {
        return this.name;
    }

    long getId() {
        return this.id;
    }

    int getPriority() {
        return this.priority;
    }

    boolean isDaemon() {
        return this.daemon;
    }

    Thread.State getState() {
        return this.state;
    }

    List<StackTraceElement> getStackTrace() {
        if (this.stackTrace != null) {
            return Collections.unmodifiableList(this.stackTrace);
        }
        return this.stackTrace;
    }

    String getExecutedMethod() {
        List<StackTraceElement> trace = this.stackTrace;
        if (trace != null && !trace.isEmpty()) {
            return trace.get(0).toString();
        }
        return "";
    }

    long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    long getUserTimeMillis() {
        return this.userTimeMillis;
    }

    boolean isDeadlocked() {
        return this.deadlocked;
    }

    String getGlobalThreadId() {
        return this.globalThreadId;
    }

    private static String buildGlobalThreadId(Thread thread, String hostAddress) {
        return PID.getPID() + '_' + hostAddress + '_' + thread.getId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + ", name=" + this.getName() + ", daemon=" + this.isDaemon() + ", priority=" + this.getPriority() + ", deadlocked=" + this.isDeadlocked() + ", state=" + (Object)((Object)this.getState()) + ']';
    }
}

