/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.attached.images.bean;

import fr.toutatice.ecm.platform.web.document.ToutaticeDocumentActionsBean;
import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.codec.DocumentFileCodec;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

@Name(value="documentActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=131)
public class OttcDocumentActionsBean
extends ToutaticeDocumentActionsBean {
    private static final long serialVersionUID = -7497960175016224842L;
    private static final Log log = LogFactory.getLog(OttcDocumentActionsBean.class);

    public void download(DocumentView docView) throws ClientException {
        if (docView != null) {
            DocumentLocation docLoc = docView.getDocumentLocation();
            if (this.documentManager == null) {
                RepositoryLocation loc = new RepositoryLocation(docLoc.getServerName());
                this.navigationContext.setCurrentServerLocation(loc);
                this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            }
            DocumentModel doc = null;
            doc = docLoc.getDocRef() == null ? super.getCurrentDocument() : this.documentManager.getDocument(docLoc.getDocRef());
            if (doc != null) {
                Blob blob = DocumentFileCodec.getBlob((DocumentModel)doc, (DocumentView)docView);
                if (blob == null) {
                    log.warn((Object)("No blob for docView: " + docView));
                    return;
                }
                String filename = DocumentFileCodec.getFilename((DocumentModel)doc, (DocumentView)docView);
                FacesContext context = FacesContext.getCurrentInstance();
                if (blob.getLength() > Functions.getBigFileSizeLimit()) {
                    HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
                    HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
                    String bigDownloadURL = BaseURL.getBaseURL((ServletRequest)request);
                    bigDownloadURL = bigDownloadURL + "nxbigfile/";
                    bigDownloadURL = bigDownloadURL + doc.getRepositoryName() + "/";
                    bigDownloadURL = bigDownloadURL + doc.getRef().toString() + "/";
                    bigDownloadURL = bigDownloadURL + docView.getParameter("FILE_PROPERTY_PATH") + "/";
                    bigDownloadURL = bigDownloadURL + URIUtils.quoteURIPathComponent((String)filename, (boolean)true);
                    try {
                        response.sendRedirect(bigDownloadURL);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while redirecting for big file downloader", (Throwable)e);
                    }
                } else {
                    ComponentUtils.download((FacesContext)context, (Blob)blob, (String)filename);
                }
            }
        }
    }
}

