/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.list;

import com.phloc.commons.IHasSize;
import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.MustImplementEqualsAndHashcode;
import com.phloc.commons.factory.FactoryNull;
import com.phloc.commons.factory.IFactory;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SafeArrayList<ELEMENTTYPE>
extends ArrayList<ELEMENTTYPE>
implements IHasSize {
    @MustImplementEqualsAndHashcode
    private final IFactory<ELEMENTTYPE> m_aFactory;

    public SafeArrayList() {
        this(FactoryNull.getInstance());
    }

    public SafeArrayList(@Nonnull IFactory<ELEMENTTYPE> iFactory) {
        this.m_aFactory = ValueEnforcer.notNull(iFactory, "Factory");
    }

    private void _ensureSize(@Nonnegative int n) {
        while (this.size() <= n) {
            this.add(this.m_aFactory.create());
        }
    }

    @Override
    public ELEMENTTYPE get(@Nonnegative int n) {
        this._ensureSize(n);
        return (ELEMENTTYPE)super.get(n);
    }

    @Override
    public ELEMENTTYPE set(@Nonnegative int n, @Nonnull ELEMENTTYPE ELEMENTTYPE) {
        this._ensureSize(n);
        return super.set(n, ELEMENTTYPE);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SafeArrayList safeArrayList = (SafeArrayList)object;
        return this.m_aFactory.equals(safeArrayList.m_aFactory);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("factory", this.m_aFactory).toString();
    }
}

