/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.triple;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.collections.triple.IReadonlyTriple;
import com.phloc.commons.collections.triple.ITriple;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Triple<DATA1TYPE, DATA2TYPE, DATA3TYPE>
implements ITriple<DATA1TYPE, DATA2TYPE, DATA3TYPE> {
    private DATA1TYPE m_aFirst;
    private DATA2TYPE m_aSecond;
    private DATA3TYPE m_aThird;

    public <T2 extends DATA1TYPE, U2 extends DATA2TYPE, V2 extends DATA3TYPE> Triple(@Nullable T2 T2, @Nullable U2 U2, @Nullable V2 V2) {
        this.m_aFirst = T2;
        this.m_aSecond = U2;
        this.m_aThird = V2;
    }

    public Triple(@Nonnull IReadonlyTriple<? extends DATA1TYPE, ? extends DATA2TYPE, ? extends DATA3TYPE> iReadonlyTriple) {
        ValueEnforcer.notNull(iReadonlyTriple, "Triple");
        this.m_aFirst = iReadonlyTriple.getFirst();
        this.m_aSecond = iReadonlyTriple.getSecond();
        this.m_aThird = iReadonlyTriple.getThird();
    }

    @Override
    @Nullable
    public DATA1TYPE getFirst() {
        return this.m_aFirst;
    }

    @Override
    @Nonnull
    public EChange setFirst(@Nullable DATA1TYPE DATA1TYPE) {
        if (EqualsUtils.equals(DATA1TYPE, this.m_aFirst)) {
            return EChange.UNCHANGED;
        }
        this.m_aFirst = DATA1TYPE;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public DATA2TYPE getSecond() {
        return this.m_aSecond;
    }

    @Override
    @Nonnull
    public EChange setSecond(@Nullable DATA2TYPE DATA2TYPE) {
        if (EqualsUtils.equals(DATA2TYPE, this.m_aSecond)) {
            return EChange.UNCHANGED;
        }
        this.m_aSecond = DATA2TYPE;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public DATA3TYPE getThird() {
        return this.m_aThird;
    }

    @Override
    @Nonnull
    public EChange setThird(@Nullable DATA3TYPE DATA3TYPE) {
        if (EqualsUtils.equals(DATA3TYPE, this.m_aThird)) {
            return EChange.UNCHANGED;
        }
        this.m_aThird = DATA3TYPE;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Triple)) {
            return false;
        }
        Triple triple = (Triple)object;
        return EqualsUtils.equals(this.m_aFirst, triple.m_aFirst) && EqualsUtils.equals(this.m_aSecond, triple.m_aSecond) && EqualsUtils.equals(this.m_aThird, triple.m_aThird);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFirst).append(this.m_aSecond).append(this.m_aThird).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("first", this.m_aFirst).append("second", this.m_aSecond).append("third", this.m_aThird).toString();
    }

    @Nonnull
    public static <T, U, V> ITriple<T, U, V> create(@Nullable T t, @Nullable U u, @Nullable V v) {
        return new Triple(t, u, v);
    }
}

