/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.locale.country;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.locale.LocaleCache;
import com.phloc.commons.locale.LocaleUtils;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CountryCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CountryCache.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Set<String> s_aCountries = new HashSet<String>();
    private static final CountryCache s_aInstance;

    private CountryCache() {
    }

    private static void _initialFillCache() {
        for (Locale locale : LocaleCache.getAllLocales()) {
            String string = locale.getCountry();
            if (!StringHelper.hasText(string)) continue;
            CountryCache.addCountry(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    static EChange addCountry(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Country");
        String string2 = LocaleUtils.getValidCountryCode(string);
        if (string2 == null) {
            throw new IllegalArgumentException("illegal country code '" + string + "'");
        }
        if (!string.equals(string2)) {
            throw new IllegalArgumentException("invalid casing of '" + string + "'");
        }
        s_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(s_aCountries.add(string2));
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    public static Locale getCountry(@Nullable Locale locale) {
        return locale == null ? null : CountryCache.getCountry(locale.getCountry());
    }

    @Nullable
    public static Locale getCountry(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        if (string.indexOf(95) >= 0) {
            return CountryCache.getCountry(LocaleCache.getLocale(string));
        }
        String string2 = LocaleUtils.getValidCountryCode(string);
        if (!CountryCache.containsCountry(string2)) {
            s_aLogger.warn("Trying to retrieve unsupported country " + string);
        }
        return LocaleCache.getLocale("", string2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllCountries() {
        s_aRWLock.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aCountries);
            return set;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Locale> getAllCountryLocales() {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        for (String string : CountryCache.getAllCountries()) {
            hashSet.add(LocaleCache.getLocale("", string, ""));
        }
        return hashSet;
    }

    public static boolean containsCountry(@Nullable Locale locale) {
        return locale != null && CountryCache.containsCountry(locale.getCountry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsCountry(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = LocaleUtils.getValidCountryCode(string);
        if (string2 == null) {
            return false;
        }
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_aCountries.contains(string2);
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        s_aRWLock.writeLock().lock();
        try {
            s_aCountries.clear();
            CountryCache._initialFillCache();
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Cache was reset: " + CountryCache.class.getName());
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    static {
        CountryCache._initialFillCache();
        s_aInstance = new CountryCache();
    }
}

