/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mime;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.id.IHasID;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.mime.MimeType;
import com.phloc.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EMimeContentType implements IHasID<String>
{
    APPLICATION("application"),
    AUDIO("audio"),
    EXAMPLE("example"),
    IMAGE("image"),
    MESSAGE("message"),
    MODEL("model"),
    MULTIPART("multipart"),
    TEXT("text"),
    VIDEO("video"),
    _STAR("*");

    private final String m_sText;

    private EMimeContentType(String string2) {
        this.m_sText = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sText;
    }

    @Nonnull
    @Nonempty
    public String getText() {
        return this.m_sText;
    }

    @Nonnull
    public MimeType buildMimeType(@Nonnull @Nonempty String string) {
        return new MimeType(this, string);
    }

    public boolean isTypeOf(@Nullable String string) {
        return StringHelper.startsWith((CharSequence)string, this.m_sText + '/');
    }

    @Nullable
    public static EMimeContentType getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDCaseInsensitiveOrNull(EMimeContentType.class, string);
    }
}

