/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.type;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.type.ITypedObject;
import com.phloc.commons.type.ObjectType;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TypedObject<IDTYPE extends Serializable>
implements ITypedObject<IDTYPE>,
Serializable {
    private final ObjectType m_aTypeID;
    private final IDTYPE m_aID;

    public TypedObject(@Nonnull ITypedObject<IDTYPE> iTypedObject) {
        this(iTypedObject.getTypeID(), (Serializable)iTypedObject.getID());
    }

    public TypedObject(@Nonnull ObjectType objectType, @Nonnull IDTYPE IDTYPE) {
        this.m_aTypeID = ValueEnforcer.notNull(objectType, "TypeID");
        this.m_aID = (Serializable)ValueEnforcer.notNull(IDTYPE, "ID");
    }

    @Override
    @Nonnull
    public ObjectType getTypeID() {
        return this.m_aTypeID;
    }

    @Override
    @Nonnull
    public IDTYPE getID() {
        return this.m_aID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TypedObject)) {
            return false;
        }
        TypedObject typedObject = (TypedObject)object;
        return this.m_aTypeID.equals(typedObject.m_aTypeID) && this.m_aID.equals(typedObject.m_aID);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aTypeID).append(this.m_aID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("type", this.m_aTypeID).append("id", this.m_aID).toString();
    }

    @Nonnull
    public static <IDTYPE extends Serializable> TypedObject<IDTYPE> create(@Nonnull ITypedObject<IDTYPE> iTypedObject) {
        return new TypedObject<IDTYPE>(iTypedObject);
    }

    @Nonnull
    public static <IDTYPE extends Serializable> TypedObject<IDTYPE> create(@Nonnull ObjectType objectType, @Nonnull IDTYPE IDTYPE) {
        return new TypedObject<IDTYPE>(objectType, IDTYPE);
    }
}

