/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.vendor;

import com.phloc.commons.CGlobal;
import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.email.EmailAddressUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.url.EURLProtocol;
import com.phloc.commons.url.IURLProtocol;
import com.phloc.commons.url.URLProtocolRegistry;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class VendorInfo {
    public static final String DEFAULT_VENDOR_LOCATION = "Vienna, Austria, Europe, World, Milky Way, Universe";
    public static final String DEFAULT_VENDOR_NAME = "phloc systems";
    public static final String DEFAULT_VENDOR_URL_WITHOUT_PROTOCOL = "www.phloc.com";
    public static final String DEFAULT_VENDOR_URL = "http://www.phloc.com";
    public static final String VENDOR_PERSON_BORIS = "Boris Gregorcic";
    public static final String VENDOR_PERSON_PHILIP = "Philip Helger";
    public static final String DEFAULT_VENDOR_EMAIL_SUFFIX = "@phloc.com";
    public static final String DEFAULT_VENDOR_EMAIL = "office@phloc.com";
    public static final int DEFAULT_INCEPTION_YEAR = 2004;
    private static final VendorInfo s_aInstance = new VendorInfo();
    private static String s_sVendorLocation = "Vienna, Austria, Europe, World, Milky Way, Universe";
    private static int s_nInceptionYear = 2004;
    private static String s_sVendorName = "phloc systems";
    private static String s_sVendorURLWithoutProtocol = "www.phloc.com";
    private static String s_sVendorURL = "http://www.phloc.com";
    private static String s_sVendorEmailSuffix = "@phloc.com";
    private static String s_sVendorEmail = "office@phloc.com";

    private VendorInfo() {
    }

    @Nonnull
    public static String getVendorLocation() {
        return s_sVendorLocation;
    }

    public static void setVendorLocation(@Nonnull @Nonempty String string) {
        s_sVendorLocation = ValueEnforcer.notEmpty(string, "VendorLocation");
    }

    @Nonnegative
    public static int getInceptionYear() {
        return s_nInceptionYear;
    }

    public static void setInceptionYear(@Nonnegative int n) {
        s_nInceptionYear = ValueEnforcer.isGE0(n, "InceptionYear");
    }

    @Nonnull
    public static String getVendorName() {
        return s_sVendorName;
    }

    public static void setVendorName(@Nonnull @Nonempty String string) {
        s_sVendorName = ValueEnforcer.notEmpty(string, "VendorName");
    }

    @Nonnull
    public static String getVendorURLWithoutProtocol() {
        return s_sVendorURLWithoutProtocol;
    }

    @Nonnull
    public static String getVendorURL() {
        return s_sVendorURL;
    }

    public static void setVendorURL(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "VendorURL");
        IURLProtocol iURLProtocol = URLProtocolRegistry.getProtocol(string);
        if (iURLProtocol == null) {
            s_sVendorURLWithoutProtocol = string;
            s_sVendorURL = EURLProtocol.HTTP.getWithProtocol(string);
        } else {
            s_sVendorURLWithoutProtocol = string.substring(iURLProtocol.getProtocol().length());
            s_sVendorURL = string;
        }
    }

    @Nonnull
    public static String getVendorEmail() {
        return s_sVendorEmail;
    }

    @Nonnull
    public static String getVendorEmailSuffix() {
        return s_sVendorEmailSuffix;
    }

    public static void setVendorEmail(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "VendorEmail");
        if (!EmailAddressUtils.isValid(string)) {
            throw new IllegalArgumentException("Illegal vendor email: " + string);
        }
        s_sVendorEmail = string;
        s_sVendorEmailSuffix = StringHelper.getFromFirstIncl(string, '@');
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getFileHeaderLines() {
        return ContainerHelper.newList("THIS FILE IS GENERATED - DO NOT EDIT", "", "Copyright", "", "Copyright (c) " + VendorInfo.getVendorName() + " " + VendorInfo.getInceptionYear() + " - " + CGlobal.CURRENT_YEAR, VendorInfo.getVendorURL(), "", "All Rights Reserved", "Use, duplication or disclosure restricted by " + VendorInfo.getVendorName(), "", VendorInfo.getVendorLocation() + ", " + VendorInfo.getInceptionYear() + " - " + CGlobal.CURRENT_YEAR);
    }
}

