/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.xml.CXML;
import com.phloc.commons.xml.ChildElementIterator;
import com.phloc.commons.xml.FilterElementWithNamespace;
import com.phloc.commons.xml.FilterElementWithNamespaceAndLocalName;
import com.phloc.commons.xml.FilterElementWithTagName;
import com.phloc.commons.xml.FilterElementWithoutNamespace;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Immutable
public final class XMLHelper {
    private static final XMLHelper s_aInstance = new XMLHelper();

    private XMLHelper() {
    }

    @Nullable
    public static Element getFirstChildElement(@Nonnull Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            return (Element)node2;
        }
        return null;
    }

    public static boolean hasChildElementNodes(@Nonnull Node node) {
        return XMLHelper.getFirstChildElement(node) != null;
    }

    @Nullable
    public static Element getFirstChildElementOfName(@Nonnull Node node, @Nullable String string) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !(element = (Element)node2).getTagName().equals(string)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public static Document getOwnerDocument(@Nullable Node node) {
        return node == null ? null : (node instanceof Document ? (Document)node : node.getOwnerDocument());
    }

    @Nonnull
    public static Node append(@Nonnull Node node, @Nullable Object object) {
        ValueEnforcer.notNull(node, "ParentNode");
        if (object != null) {
            if (object instanceof Document) {
                XMLHelper.append(node, ((Document)object).getDocumentElement());
            } else if (object instanceof Node) {
                Node node2 = (Node)object;
                Document document = XMLHelper.getOwnerDocument(node);
                if (XMLHelper.getOwnerDocument(node2).equals(document)) {
                    node.appendChild(node2);
                } else {
                    node.appendChild(document.adoptNode(node2.cloneNode(true)));
                }
            } else if (object instanceof String) {
                node.appendChild(XMLHelper.getOwnerDocument(node).createTextNode((String)object));
            } else if (object instanceof Iterable) {
                for (Object t : (Iterable)object) {
                    XMLHelper.append(node, t);
                }
            } else if (ArrayHelper.isArray(object)) {
                for (Object object2 : (Object[])object) {
                    XMLHelper.append(node, object2);
                }
            } else {
                throw new IllegalArgumentException("Passed object cannot be appended to a DOMNode (type=" + object.getClass().getName() + ".");
            }
        }
        return node;
    }

    public static void append(@Nonnull Node node, @Nonnull Collection<?> collection) {
        for (Object obj : collection) {
            XMLHelper.append(node, obj);
        }
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element element) {
        return element == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNoNS(element));
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element element, @Nonnull @Nonempty String string) {
        return element == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNoNS(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element element, @Nullable String string) {
        return element == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNS(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element element, @Nullable String string, @Nonnull @Nonempty String string2) {
        return element == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNS(element, string, string2));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNoNS(@Nonnull Node node) {
        return new ChildElementIterator(node, FilterElementWithoutNamespace.getInstance());
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNoNS(@Nonnull Node node, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "TagName");
        return new ChildElementIterator(node, new FilterElementWithTagName(string));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNS(@Nonnull Node node, @Nullable String string) {
        return new ChildElementIterator(node, new FilterElementWithNamespace(string));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNS(@Nonnull Node node, @Nullable String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty(string2, "LocalName");
        return new ChildElementIterator(node, new FilterElementWithNamespaceAndLocalName(string, string2));
    }

    public static boolean hasNamespaceURI(@Nullable Node node, @Nullable String string) {
        String string2 = node == null ? null : node.getNamespaceURI();
        return string2 != null && string2.equals(string);
    }

    @Nonnull
    public static String getPathToNode(@Nonnull Node node) {
        return XMLHelper.getPathToNode(node, "/");
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static String getPathToNode(@Nonnull Node node, @Nonnull String string) {
        ValueEnforcer.notNull(node, "Node");
        ValueEnforcer.notNull(string, "Separator");
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            StringBuilder stringBuilder2 = new StringBuilder(node2.getNodeName());
            if (node2.getNodeType() == 1 && node2.getParentNode() != null) {
                Element element;
                Element element2 = (Element)node2;
                int n = 0;
                Iterator iterator = XMLHelper.getChildElementIteratorNoNS(node2.getParentNode()).iterator();
                while (iterator.hasNext() && (element = (Element)iterator.next()) != node2) {
                    if (!element.getTagName().equals(element2.getTagName())) continue;
                    ++n;
                }
                stringBuilder2.append('[').append(n).append(']');
            }
            stringBuilder.insert(0, string).insert(0, stringBuilder2);
        }
        return stringBuilder.toString();
    }

    public static void removeAllChildElements(@Nonnull Element element) {
        while (element.getChildNodes().getLength() > 0) {
            element.removeChild(element.getChildNodes().item(0));
        }
    }

    public static boolean isTextNode(@Nullable Node node) {
        return node instanceof CharacterData && !(node instanceof Comment) || node instanceof EntityReference;
    }

    @Nullable
    public static String getFirstChildText(@Nullable Node node) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Text text;
                Node node2 = nodeList.item(i);
                if (!(node2 instanceof Text) || (text = (Text)node2).isElementContentWhitespace()) continue;
                return text.getData();
            }
        }
        return null;
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element element, @Nonnull String string) {
        return XMLHelper.getAttributeValue(element, string, null);
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element element, @Nonnull String string, @Nullable String string2) {
        Attr attr = element.getAttributeNode(string);
        return attr == null ? string2 : attr.getValue();
    }

    @Nullable
    public static Map<String, String> getAllAttributesAsMap(@Nullable Element element) {
        NamedNodeMap namedNodeMap;
        if (element != null && (namedNodeMap = element.getAttributes()) != null) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(namedNodeMap.getLength());
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                linkedHashMap.put(attr.getName(), attr.getValue());
            }
            return linkedHashMap;
        }
        return null;
    }

    @Nonnull
    public static String getXMLNSAttrName(@Nullable String string) {
        if (string != null && string.contains(CXML.XML_PREFIX_NAMESPACE_SEP_STR)) {
            throw new IllegalArgumentException("prefix is invalid: " + string);
        }
        if (string == null || string.equals("")) {
            return "xmlns";
        }
        return "xmlns:" + string;
    }

    @Nullable
    public static String getNamespaceURI(@Nullable Node node) {
        if (node instanceof Document) {
            return XMLHelper.getNamespaceURI(((Document)node).getDocumentElement());
        }
        if (node != null) {
            return node.getNamespaceURI();
        }
        return null;
    }

    @Nonnegative
    public static int getLength(@Nullable NodeList nodeList) {
        return nodeList == null ? 0 : nodeList.getLength();
    }

    public static boolean isEmpty(@Nullable NodeList nodeList) {
        return XMLHelper.getLength(nodeList) == 0;
    }
}

