/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.xpath;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.xml.xpath.XPathHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NotThreadSafe
public final class XPathExpressionHelper {
    private static final XPathExpressionHelper s_aInstance = new XPathExpressionHelper();

    private XPathExpressionHelper() {
    }

    @Nullable
    public static Object evalXPath(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @Nonnull String string, @Nonnull Document document, @Nonnull QName qName) {
        return XPathExpressionHelper.evalXPath(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document, qName);
    }

    @Nullable
    public static Object evalXPath(@Nonnull XPath xPath, @Nonnull @Nonempty String string, @Nonnull Document document, @Nonnull QName qName) {
        ValueEnforcer.notNull(xPath, "XPath");
        ValueEnforcer.notEmpty(string, "XPathExpression");
        ValueEnforcer.notNull(document, "Doc");
        ValueEnforcer.notNull(qName, "ReturnType");
        try {
            XPathExpression xPathExpression = XPathHelper.createNewXPathExpresion(xPath, string);
            return xPathExpression.evaluate(document, qName);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException("Failed to evaluate XPath expression '" + string + "' with return type " + qName.toString(), xPathExpressionException);
        }
    }

    @Nullable
    public static Double evalXPathToNumber(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @Nonnull String string, @Nonnull Document document) {
        return XPathExpressionHelper.evalXPathToNumber(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document);
    }

    @Nullable
    public static Double evalXPathToNumber(@Nonnull String string, @Nonnull Document document) {
        return XPathExpressionHelper.evalXPathToNumber(XPathHelper.createNewXPath(), string, document);
    }

    @Nullable
    public static Double evalXPathToNumber(@Nonnull XPath xPath, @Nonnull String string, @Nonnull Document document) {
        Object object = XPathExpressionHelper.evalXPath(xPath, string, document, XPathConstants.NUMBER);
        return (Double)object;
    }

    @Nullable
    public static String evalXPathToString(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @Nonnull String string, @Nonnull Document document) {
        return XPathExpressionHelper.evalXPathToString(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document);
    }

    @Nullable
    public static String evalXPathToString(@Nonnull String string, @Nonnull Document document) {
        return XPathExpressionHelper.evalXPathToString(XPathHelper.createNewXPath(), string, document);
    }

    @Nullable
    public static String evalXPathToString(@Nonnull XPath xPath, @Nonnull String string, @Nonnull Document document) {
        Object object = XPathExpressionHelper.evalXPath(xPath, string, document, XPathConstants.STRING);
        return (String)object;
    }

    @Nullable
    public static Boolean evalXPathToBoolean(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @Nonnull String string, @Nonnull Document document) {
        return XPathExpressionHelper.evalXPathToBoolean(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document);
    }

    @Nullable
    public static Boolean evalXPathToBoolean(@Nonnull String string, @Nonnull Document document) {
        return XPathExpressionHelper.evalXPathToBoolean(XPathHelper.createNewXPath(), string, document);
    }

    @Nullable
    public static Boolean evalXPathToBoolean(@Nonnull XPath xPath, @Nonnull String string, @Nonnull Document document) {
        Object object = XPathExpressionHelper.evalXPath(xPath, string, document, XPathConstants.BOOLEAN);
        return (Boolean)object;
    }

    @Nullable
    public static NodeList evalXPathToNodeList(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @Nonnull String string, @Nonnull Document document) {
        return XPathExpressionHelper.evalXPathToNodeList(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document);
    }

    @Nullable
    public static NodeList evalXPathToNodeList(@Nonnull String string, @Nonnull Document document) {
        return XPathExpressionHelper.evalXPathToNodeList(XPathHelper.createNewXPath(), string, document);
    }

    @Nullable
    public static NodeList evalXPathToNodeList(@Nonnull XPath xPath, @Nonnull String string, @Nonnull Document document) {
        Object object = XPathExpressionHelper.evalXPath(xPath, string, document, XPathConstants.NODESET);
        return (NodeList)object;
    }

    @Nullable
    public static Node evalXPathToNode(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @Nonnull String string, @Nonnull Document document) {
        return XPathExpressionHelper.evalXPathToNode(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document);
    }

    @Nullable
    public static Node evalXPathToNode(@Nonnull String string, @Nonnull Document document) {
        return XPathExpressionHelper.evalXPathToNode(XPathHelper.createNewXPath(), string, document);
    }

    @Nullable
    public static Node evalXPathToNode(@Nonnull XPath xPath, @Nonnull String string, @Nonnull Document document) {
        Object object = XPathExpressionHelper.evalXPath(xPath, string, document, XPathConstants.NODE);
        return (Node)object;
    }
}

