/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.security;

import java.io.Serializable;

public final class ACE
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final ACE BLOCK = new ACE("Everyone", "Everything", false);
    private final String username;
    private final String permission;
    private final boolean isGranted;

    public ACE(String username, String permission) {
        this(username, permission, true);
    }

    public ACE(String username, String permission, boolean isGranted) {
        this.username = username;
        this.permission = permission;
        this.isGranted = isGranted;
    }

    public ACE() {
        this(null, null, false);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean isGranted() {
        return this.isGranted;
    }

    public boolean isDenied() {
        return !this.isGranted;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ACE) {
            ACE ace = (ACE)obj;
            return ace.isGranted == this.isGranted && ace.username.equals(this.username) && ace.permission.equals(this.permission);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 37 + (this.isGranted ? 1 : 0);
        hash = this.username != null ? hash * 37 + this.username.hashCode() : hash;
        hash = this.permission != null ? hash * 37 + this.permission.hashCode() : hash;
        return hash;
    }

    public String toString() {
        return this.username + ':' + this.permission + ':' + this.isGranted;
    }

    public Object clone() {
        return new ACE(this.username, this.permission, this.isGranted);
    }
}

