/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.statuses;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;

public class StatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(StatusServlet.class);
    public static final String PARAM = "info";
    public static final String PARAM_STARTED = "started";
    public static final String PARAM_SUMMARY = "summary";
    public static final String PARAM_SUMMARY_KEY = "key";
    public static final String PARAM_RELOAD = "reload";
    public static final String PARAM_STATUS_KEY = "server.status.key";
    private OSGiRuntimeService runtimeService;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String param = req.getParameter(PARAM);
        if (param != null) {
            this.doPost(req, resp);
        } else {
            this.sendResponse(resp, "Ok");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StringBuilder response = new StringBuilder();
        String requestedInfo = req.getParameter(PARAM);
        if (requestedInfo.equals(PARAM_STARTED)) {
            this.getStartedInfo(response);
        } else if (requestedInfo.equals(PARAM_SUMMARY)) {
            String givenKey = req.getParameter(PARAM_SUMMARY_KEY);
            if (this.getRuntimeService().getProperty(PARAM_STATUS_KEY).equals(givenKey)) {
                this.getSummaryInfo(response);
            } else {
                resp.setStatus(403);
            }
        } else if (requestedInfo.equals(PARAM_RELOAD)) {
            if (this.isStarted()) {
                response.append("reload();");
            } else {
                resp.setStatus(503);
            }
        }
        this.sendResponse(resp, response.toString());
    }

    protected void sendResponse(HttpServletResponse resp, String response) throws IOException {
        resp.setContentType("text/plain");
        resp.setContentLength(response.getBytes().length);
        ServletOutputStream out = resp.getOutputStream();
        out.write(response.getBytes());
        out.close();
    }

    private RuntimeService getRuntimeService() {
        if (this.runtimeService == null) {
            try {
                this.runtimeService = (OSGiRuntimeService)Framework.getRuntime();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return this.runtimeService;
    }

    protected void getSummaryInfo(StringBuilder response) {
        if (this.isStarted()) {
            StringBuilder msg = new StringBuilder();
            boolean isFine = this.runtimeService.getStatusMessage(msg);
            response.append(isFine).append("\n");
            response.append((CharSequence)msg);
        } else {
            response.append(false).append("\n");
            response.append("Runtime failed to start");
        }
    }

    protected void getStartedInfo(StringBuilder response) {
        response.append(this.isStarted()).toString();
    }

    private boolean isStarted() {
        return this.getRuntimeService() != null && this.runtimeService.isStarted();
    }

    public void init() throws ServletException {
        log.debug((Object)"Ready.");
    }
}

