/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import net.bull.javamelody.internal.common.Parameters;

class StorageLock {
    private static final String LOCK_FILENAME = "javamelody.lock";
    private final File lockFile;
    private RandomAccessFile input;
    private FileChannel fileChannel;
    private FileLock fileLock;

    StorageLock(String application) {
        this(new File(Parameters.getStorageDirectory(application), LOCK_FILENAME));
    }

    StorageLock(File lockFile) {
        this.lockFile = lockFile;
        this.getFileLock();
    }

    void release() throws IOException {
        try {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.release();
            }
        }
        finally {
            try {
                if (this.fileChannel != null) {
                    this.fileChannel.close();
                }
            }
            finally {
                if (this.input != null) {
                    this.input.close();
                }
            }
        }
    }

    private FileLock getFileLock() {
        if (this.fileLock == null) {
            try {
                File storageDir = this.lockFile.getParentFile();
                if (!storageDir.mkdirs() && !storageDir.exists()) {
                    return null;
                }
                if (this.input == null || this.fileChannel == null) {
                    this.input = new RandomAccessFile(this.lockFile, "rw");
                    this.fileChannel = this.input.getChannel();
                }
                this.fileLock = this.fileChannel.tryLock();
            }
            catch (IOException e) {
                return null;
            }
            catch (OverlappingFileLockException e) {
                return null;
            }
        }
        return this.fileLock;
    }

    boolean isAcquired() {
        return this.getFileLock() != null && this.getFileLock().isValid();
    }
}

