/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.onlyoffice.listener;

import fr.toutatice.ecm.platform.core.edition.CurrentlyEditedCacheHelper;
import fr.toutatice.ecm.platform.core.edition.TemporaryLockedCacheHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Principal;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;
import org.osivia.onlyoffice.util.FileUtility;

public class OnlyofficeSaveDocumentListener
implements EventListener {
    protected static final Log oolog = LogFactory.getLog((String)"onlyoffice");
    private static final String OTTC_ONLYOFFICE_PROXY_PATH = "ottc.onlyoffice.proxy.path";
    private static final String OTTC_ONLYOFFICE_SERVER_URL = "ottc.onlyoffice.server.url";
    public static final String ONLYOFFICE_SAVEDOCUMENT_EVENT_NAME = "OnlyofficeSaveDocumentEvent";
    public static final String ONLYOFFICE_CALLBACK_STATUS_PROPERTY = "OnlyofficeCallbackStatus";
    public static final String ONLYOFFICE_CALLBACK_URL_PROPERTY = "OnlyofficeCallbackUrl";
    private static Log log = LogFactory.getLog(OnlyofficeSaveDocumentListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            CoreSession session = docCtx.getCoreSession();
            DocumentModel doc = docCtx.getSourceDocument();
            Integer status = (Integer)docCtx.getProperty(ONLYOFFICE_CALLBACK_STATUS_PROPERTY);
            String url = (String)((Object)docCtx.getProperty(ONLYOFFICE_CALLBACK_URL_PROPERTY));
            if (status != null && url != null && status == 2) {
                try {
                    String docTitle = doc.getTitle();
                    BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
                    Blob originalBlob = bh.getBlob();
                    String originalFilename = originalBlob.getFilename();
                    String originalExt = FileUtility.getFileExtension(originalFilename);
                    String onlyofficeExt = FileUtility.getOnlyOfficeExtension(originalFilename);
                    String updatedFilename = FileUtility.getFileNameWithoutExtension(originalFilename) + onlyofficeExt;
                    if (StringUtils.equalsIgnoreCase((String)docTitle, (String)originalFilename)) {
                        doc.setProperty("dublincore", "title", (Object)updatedFilename);
                    }
                    Serializable webid = doc.getPropertyValue("ttc:webid");
                    Principal principal = session.getPrincipal();
                    oolog.info((Object)("About to download docId:" + doc.getId() + " webid:" + webid + " userId:" + principal.getName()));
                    long btime = new Date().getTime();
                    Blob blob = this.getOnlyofficeBlob(url);
                    long etime = new Date().getTime();
                    oolog.info((Object)("Downloaded docId:" + doc.getId() + " webid:" + webid + " userId:" + principal.getName() + " time:" + (etime - btime) + "ms"));
                    blob.setFilename(updatedFilename);
                    blob.setMimeType(FileUtility.getOnlyofficeMimeType(originalFilename));
                    bh.setBlob(blob);
                    if (!originalExt.equalsIgnoreCase(onlyofficeExt) || session.isCheckedOut(doc.getRef())) {
                        if (!session.isCheckedOut(doc.getRef())) {
                            session.checkOut(doc.getRef());
                        }
                        session.checkIn(doc.getRef(), VersioningOption.NONE, "historisation avant modification onlyoffice");
                    }
                    if (!originalExt.equalsIgnoreCase(onlyofficeExt)) {
                        doc.putContextData("VersioningOption", (Serializable)VersioningOption.MINOR);
                    } else {
                        doc.putContextData("VersioningOption", (Serializable)VersioningOption.MINOR);
                    }
                    session.saveDocument(doc);
                    long stime = new Date().getTime();
                    oolog.info((Object)("Saved docId:" + doc.getId() + "  webid:" + webid + " userId:" + principal.getName() + " time:" + (stime - etime) + "ms"));
                }
                catch (Exception e) {
                    log.error((Object)"erreur", e.getCause());
                    oolog.error((Object)("Error on docId:" + doc.getId() + " " + e.getMessage()));
                }
                CurrentlyEditedCacheHelper.invalidate((DocumentModel)doc);
                if (TemporaryLockedCacheHelper.get((DocumentModel)doc) != null) {
                    session.removeLock(doc.getRef());
                    TemporaryLockedCacheHelper.invalidate((DocumentModel)doc);
                }
            }
        }
    }

    private Blob getOnlyofficeBlob(String downloadUri) {
        ByteArrayBlob byteArrayBlob;
        HttpURLConnection connection = null;
        InputStream stream = null;
        try {
            URL url = new URL(downloadUri);
            String onlyOfficeUrl = Framework.getProperty((String)OTTC_ONLYOFFICE_SERVER_URL);
            if (StringUtils.isNotBlank((String)onlyOfficeUrl)) {
                String path = url.getPath().replace(Framework.getProperty((String)OTTC_ONLYOFFICE_PROXY_PATH), "");
                url = new URL(onlyOfficeUrl + path + "?" + url.getQuery());
            }
            connection = (HttpURLConnection)url.openConnection();
            stream = connection.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)stream);
            byteArrayBlob = new ByteArrayBlob(bytes);
        }
        catch (IOException e) {
            try {
                throw new ClientException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                if (connection != null) {
                    connection.disconnect();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        if (connection != null) {
            connection.disconnect();
        }
        return byteArrayBlob;
    }
}

