/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.onlyoffice.rest;

import fr.toutatice.ecm.platform.core.edition.CurrentlyEditedCacheHelper;
import fr.toutatice.ecm.platform.core.edition.TemporaryLockedCacheHelper;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;
import org.osivia.onlyoffice.rest.OnlyofficeCallback;

@Path(value="/onlyoffice")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@WebObject(type="OnlyOffice")
public class OnlyofficeRestService
extends ModuleRoot {
    protected static final Log log = LogFactory.getLog((String)"onlyoffice");
    private final EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
    private final Map<Integer, String> messages = new HashMap<Integer, String>();

    public OnlyofficeRestService() {
        this.messages.put(1, "document is being edited");
        this.messages.put(2, "document is ready for saving");
        this.messages.put(3, "document saving error has occurred");
        this.messages.put(4, "document is closed with no change");
        this.messages.put(6, "document is being edited, but the current document state is saved");
        this.messages.put(7, "error has occurred while force saving the document");
    }

    @Path(value="callbackEdit/{docId}")
    @POST
    public Object callbackEdit(@PathParam(value="docId") String docId, OnlyofficeCallback onlyofficeCallback) {
        CoreSession session = this.getSession();
        DocumentModel documentModel = session.getDocument((DocumentRef)new IdRef(docId));
        Principal principal = session.getPrincipal();
        DocumentEventContext eventCtx = new DocumentEventContext(session, principal, documentModel);
        int status = onlyofficeCallback.getStatus();
        log.info((Object)("callback docId:" + docId + " userId:" + principal.getName() + " status:" + status + " (" + this.messages.get(status) + ")"));
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("OnlyofficeCallbackStatus", onlyofficeCallback.getStatus());
        properties.put("OnlyofficeCallbackUrl", onlyofficeCallback.getUrl());
        eventCtx.setProperties(properties);
        Object statusMsg = null;
        switch (status) {
            case 0: {
                CurrentlyEditedCacheHelper.invalidate((DocumentModel)documentModel);
                this.removeLockIfExists(session, documentModel);
                break;
            }
            case 1: {
                CurrentlyEditedCacheHelper.put((DocumentModel)documentModel, onlyofficeCallback.getUsers());
                break;
            }
            case 2: {
                this.eventProducer.fireEvent(eventCtx.newEvent("OnlyofficeSaveDocumentEvent"));
                break;
            }
            case 3: {
                CurrentlyEditedCacheHelper.invalidate((DocumentModel)documentModel);
                this.removeLockIfExists(session, documentModel);
            }
            case 4: {
                CurrentlyEditedCacheHelper.invalidate((DocumentModel)documentModel);
                this.removeLockIfExists(session, documentModel);
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                break;
            }
        }
        return "{\"error\":0}";
    }

    private void removeLockIfExists(CoreSession session, DocumentModel doc) {
        if (TemporaryLockedCacheHelper.get((DocumentModel)doc) != null) {
            session.removeLock(doc.getRef());
            TemporaryLockedCacheHelper.invalidate((DocumentModel)doc);
        }
    }

    @Path(value="callbackCoEdit/{docId}")
    @POST
    public Object callbackCoEdit(@PathParam(value="docId") String docId) {
        return docId;
    }

    private DocumentModel getDocument(String docId) {
        return this.getSession().getDocument((DocumentRef)new IdRef(docId));
    }

    private CoreSession getSession() {
        return SessionFactory.getSession();
    }
}

