/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.onlyoffice.util;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.nuxeo.ecm.core.api.Blob;
import org.osivia.onlyoffice.util.FileType;

public class FileUtility {
    public static final String SPREADSHEET_EXTENSION = ".xlsx";
    public static final String PRESENTATION_EXTENSION = ".pptx";
    public static final String TEXT_EXTENSION = ".docx";
    public static final String XLSX_MIME_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String PPTX_MIME_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    public static final String DOCX_MIME_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    protected static final List<String> ExtsDocument = Arrays.asList(".docx", ".doc", ".odt", ".rtf", ".txt", ".html", ".htm", ".mht", ".djvu", ".fb2", ".epub", ".xps");
    protected static final List<String> ExtsSpreadsheet = Arrays.asList(".xls", ".xlsx", ".ods", ".csv", ".xlsm", ".xlst");
    protected static final List<String> ExtsPresentation = Arrays.asList(".pps", ".ppsx", ".ppt", ".pptx", ".odp");

    private FileUtility() {
    }

    public static FileType getFileType(String fileName) {
        String ext = FileUtility.getFileExtension(fileName).toLowerCase();
        if (ExtsDocument.contains(ext)) {
            return FileType.TEXT;
        }
        if (ExtsSpreadsheet.contains(ext)) {
            return FileType.SPREADSHEET;
        }
        if (ExtsPresentation.contains(ext)) {
            return FileType.PRESENTATION;
        }
        return FileType.TEXT;
    }

    public static boolean isManaged(String fileName) {
        String ext = FileUtility.getFileExtension(fileName).toLowerCase();
        return ExtsDocument.contains(ext) || ExtsSpreadsheet.contains(ext) || ExtsPresentation.contains(ext);
    }

    public static boolean isValidMimetype(Blob blob) {
        return FileUtility.isValidMimetype(blob.getFilename(), blob.getMimeType());
    }

    public static boolean isValidMimetype(String filename, String mimetype) {
        return FileUtility.getOnlyofficeMimeType(filename).equalsIgnoreCase(mimetype);
    }

    public static String getOnlyofficeMimeType(String filename) {
        FileType fileType = FileUtility.getFileType(filename);
        switch (fileType) {
            case TEXT: {
                return DOCX_MIME_TYPE;
            }
            case PRESENTATION: {
                return PPTX_MIME_TYPE;
            }
            case SPREADSHEET: {
                return XLSX_MIME_TYPE;
            }
        }
        return DOCX_MIME_TYPE;
    }

    public static String getOnlyOfficeExtension(String filename) {
        FileType fileType = FileUtility.getFileType(filename);
        switch (fileType) {
            case TEXT: {
                return TEXT_EXTENSION;
            }
            case PRESENTATION: {
                return PRESENTATION_EXTENSION;
            }
            case SPREADSHEET: {
                return SPREADSHEET_EXTENSION;
            }
        }
        return TEXT_EXTENSION;
    }

    public static String getFileName(String url) {
        if (url == null) {
            return "";
        }
        return url.substring(url.lastIndexOf(47) + 1, url.length());
    }

    public static String getFileNameWithoutExtension(String url) {
        String fileName = FileUtility.getFileName(url);
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public static String getFileExtension(String url) {
        String fileName = FileUtility.getFileName(url);
        String fileExt = fileName.substring(fileName.lastIndexOf(46));
        return fileExt.toLowerCase();
    }

    public static String getEncoded(String ... strings) {
        StringBuilder sb = new StringBuilder(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            sb.append('.').append(strings[i].replace('.', ' '));
        }
        return Base64.encodeBase64String((byte[])sb.toString().getBytes());
    }

    public static String[] getDecoded(String string) {
        return new String(Base64.decodeBase64((String)string)).split("\\.");
    }
}

