/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.data;

import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.query.NxqlQueryConverter;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.GetDuplicateFilesByWebId", category="Document", label="Get duplicated documents by webid", description="Get documents which share the same webid, perform en ES query and aggregate by count on ttc;webid")
public class GetDuplicateFilesByWebId {
    public static final String ID = "Document.GetDuplicateFilesByWebId";
    @Param(name="numResults", required=false)
    protected String numResults = "10000";
    @Context
    protected CoreSession session;

    @OperationMethod
    public Object run() throws ClientException {
        JSONObject duplicatedItems = new JSONObject();
        ElasticSearchAdmin esAdmin = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        SearchRequestBuilder request = esAdmin.getClient().prepareSearch(new String[]{esAdmin.getIndexNameForRepository(this.session.getRepositoryName())}).setTypes(new String[]{"doc"}).setSearchType(SearchType.QUERY_THEN_FETCH);
        String NXQLClause = "select ecm:uuid from Document where ecm:isVersion = 0 and ecm:isProxy = 0";
        QueryBuilder queryBuilder = NxqlQueryConverter.toESQueryBuilder((String)NXQLClause, (CoreSession)this.session);
        request.setQuery(queryBuilder);
        TermsBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)"top_ttc:webid").field("ttc:webid")).size(Integer.parseInt(this.numResults)).order(Terms.Order.aggregation((String)"_count", (boolean)false));
        request.addAggregation((AbstractAggregationBuilder)aggregation);
        SearchResponse response = (SearchResponse)request.get();
        Map results = response.getAggregations().asMap();
        StringTerms topField = (StringTerms)results.get("top_ttc:webid");
        JSONArray docs = new JSONArray();
        for (Terms.Bucket b : topField.getBuckets()) {
            if (b.getDocCount() <= 1L) continue;
            JSONObject doc = new JSONObject();
            doc.put((Object)"webid", (Object)b.getKey());
            doc.put((Object)"count", (Object)b.getDocCount());
            docs.add((Object)doc);
        }
        duplicatedItems.put((Object)"docs", (Object)docs);
        return new StringBlob(duplicatedItems.toString(), "application/json");
    }
}

