/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.userworkspaces;

import java.security.Principal;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.userworkspace.core.service.DefaultUserWorkspaceServiceImpl;

public class TribuUserWorkspacesServiceImpl
extends DefaultUserWorkspaceServiceImpl {
    private static final Log uLog = LogFactory.getLog((String)"userprofiles");

    protected DocumentModel getCurrentUserPersonalWorkspace(Principal principal, String userName, CoreSession userCoreSession, DocumentModel context) throws ClientException {
        PathRef uwref;
        if (principal == null && StringUtils.isEmpty((String)userName)) {
            return null;
        }
        String usedUsername = principal instanceof NuxeoPrincipal ? ((NuxeoPrincipal)principal).getActingUser() : userName;
        PathRef rootref = this.getExistingUserWorkspaceRoot(userCoreSession, usedUsername, context);
        if (rootref != null && (uwref = this.getExistingUserWorkspace(userCoreSession, rootref, principal, usedUsername)) != null) {
            DocumentModel uw = userCoreSession.getDocument((DocumentRef)uwref);
            return uw;
        }
        return null;
    }

    protected PathRef getExistingUserWorkspaceRoot(CoreSession session, String username, DocumentModel context) {
        PathRef rootref = new PathRef(this.computePathUserWorkspaceRoot(session, username, context));
        if (session.exists((DocumentRef)rootref)) {
            return rootref;
        }
        return null;
    }

    protected PathRef getExistingUserWorkspace(CoreSession session, PathRef rootref, Principal principal, String username) {
        String workspacename = this.getUserWorkspaceNameForUser(username);
        PathRef uwref = this.resolveUserWorkspace(session, rootref, username, workspacename, this.maxsize);
        if (session.exists((DocumentRef)uwref)) {
            return uwref;
        }
        PathRef uwcompatref = this.resolveUserWorkspace(session, rootref, username, IdUtils.generateId((String)username, (String)"-", (boolean)false, (int)30), 30);
        if (uwcompatref != null && session.exists((DocumentRef)uwcompatref)) {
            return uwcompatref;
        }
        return null;
    }

    public void asyncCreateUserWorkspace(CoreSession session, String username) {
        PathRef existingUserWorkspace;
        DocumentModel context = session.getRootDocument();
        PathRef rootref = this.getExistingUserWorkspaceRoot(session, username, context);
        if (rootref == null) {
            PathRef ref = new PathRef(this.computePathUserWorkspaceRoot(session, username, null));
            DocumentModel userWorkspaceRoot = this.doCreateUserWorkspacesRoot(session, ref);
            rootref = new PathRef(userWorkspaceRoot.getPathAsString());
        }
        if ((existingUserWorkspace = this.getExistingUserWorkspace(session, rootref, session.getPrincipal(), username)) == null) {
            PathRef uwcompatref = this.resolveUserWorkspace(session, rootref, username, IdUtils.generateId((String)username, (String)"-", (boolean)false, (int)30), 30);
            DocumentModel documentModel = this.doCreateUserWorkspace(session, uwcompatref, session.getPrincipal(), username);
            uLog.info((Object)("Cr\u00e9ation workspace pour " + username + ", chemin:" + documentModel.getPathAsString()));
        } else {
            uLog.info((Object)("Workspace existant pour " + username + ", chemin:" + existingUserWorkspace));
        }
    }
}

