/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.ooomanager;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.nuxeo.runtime.api.Framework;

public class ConfigBuilderHelper {
    private static final String JPIPE_LIB_PATH_PROPERTY_KEY = "jod.jpipe.lib.path";
    private static final String[] UNIX_JPIPE_PATHS = new String[]{"/usr/lib/ure/lib", "/usr/lib/libreoffice/program"};
    private static final String[] MAC_JPIPE_PATHS = new String[]{"/Applications/OpenOffice.org.app/Contents/basis-link/ure-link/lib", "/Applications/LibreOffice.app/Contents/Frameworks"};

    private ConfigBuilderHelper() {
    }

    protected static void hackClassLoader() throws IOException {
        try {
            String[] paths;
            String ldPath = ConfigBuilderHelper.getLibPath();
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            for (String path : paths = (String[])field.get(null)) {
                if (!ldPath.equals(path)) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = ldPath;
            field.set(null, tmp);
            System.setProperty("java.library.path", System.getProperty("java.library.path"));
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Failed to get field handle to set library path");
        }
    }

    protected static String getLibPath() throws IOException {
        String jpipeLibPath = Framework.getProperty((String)JPIPE_LIB_PATH_PROPERTY_KEY);
        if (jpipeLibPath != null) {
            return jpipeLibPath;
        }
        jpipeLibPath = ConfigBuilderHelper.findJlibPipe();
        if (jpipeLibPath != null) {
            return jpipeLibPath;
        }
        throw new IOException("Failed to get jPipe LIbrary path.");
    }

    protected static String findJlibPipe() {
        ArrayList<String> possiblePaths = new ArrayList<String>();
        if (ConfigBuilderHelper.isLinux()) {
            possiblePaths.addAll(Arrays.asList(UNIX_JPIPE_PATHS));
        } else if (ConfigBuilderHelper.isMac()) {
            possiblePaths.addAll(Arrays.asList(MAC_JPIPE_PATHS));
        }
        for (String path : possiblePaths) {
            if (!new File(path).exists()) continue;
            return path;
        }
        return null;
    }

    protected static boolean isMac() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.toLowerCase().startsWith("mac os x");
    }

    protected static boolean isLinux() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.toLowerCase().startsWith("linux");
    }
}

