/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.propertyvalue;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.ICSSProperty;
import com.phloc.css.propertyvalue.CSSValue;
import com.phloc.css.propertyvalue.ICSSMultiValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CSSValueMultiProperty
implements ICSSMultiValue {
    private final List<CSSValue> m_aValues = new ArrayList<CSSValue>();

    public CSSValueMultiProperty(@Nonnull ICSSProperty[] iCSSPropertyArray, @Nonnull @Nonempty String string, boolean bl) {
        if (ArrayHelper.isEmpty((Object[])iCSSPropertyArray)) {
            throw new IllegalArgumentException("No properties passed!");
        }
        if (string == null) {
            throw new NullPointerException("value");
        }
        for (ICSSProperty iCSSProperty : iCSSPropertyArray) {
            this.m_aValues.add(new CSSValue(iCSSProperty, string, bl));
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSValue> getContainedValues() {
        return ContainerHelper.newList(this.m_aValues);
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        return this.m_aValues.get(0).getProp();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CSSValue cSSValue : this.m_aValues) {
            stringBuilder.append(cSSValue.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSValueMultiProperty)) {
            return false;
        }
        CSSValueMultiProperty cSSValueMultiProperty = (CSSValueMultiProperty)object;
        return ((Object)this.m_aValues).equals(cSSValueMultiProperty.m_aValues);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValues).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("values", this.m_aValues).toString();
    }
}

