/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.utils.AttributesFactory;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.syntax.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.syntax.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.util.Base64;

public class SchemaSubentryModifier {
    private static final Collection<String> BYPASS;
    private AttributesFactory factory = new AttributesFactory();
    private final SchemaPartitionDao dao;

    public SchemaSubentryModifier(SchemaPartitionDao dao) {
        this.dao = dao;
    }

    private LdapDN getDn(SchemaObject obj) throws NamingException {
        StringBuffer buf = new StringBuffer();
        buf.append("m-oid=").append(obj.getOid()).append(",ou=");
        if (obj instanceof Syntax) {
            buf.append("syntaxes");
        } else if (obj instanceof MatchingRule) {
            buf.append("matchingRules");
        } else if (obj instanceof AttributeType) {
            buf.append("attributeTypes");
        } else if (obj instanceof ObjectClass) {
            buf.append("objectClasses");
        } else if (obj instanceof MatchingRuleUse) {
            buf.append("matchingRuleUse");
        } else if (obj instanceof DITStructureRule) {
            buf.append("ditStructureRules");
        } else if (obj instanceof DITContentRule) {
            buf.append("ditContentRules");
        } else if (obj instanceof NameForm) {
            buf.append("nameForms");
        }
        buf.append(",cn=").append(obj.getSchema()).append(",ou=schema");
        return new LdapDN(buf.toString());
    }

    public void addSchemaObject(SchemaObject obj) throws NamingException {
        PartitionNexusProxy proxy = InvocationStack.getInstance().peek().getProxy();
        Schema schema = this.dao.getSchema(obj.getSchema());
        LdapDN dn = this.getDn(obj);
        Attributes attrs = this.factory.getAttributes(obj, schema);
        proxy.add(new AddOperationContext(dn, attrs), BYPASS);
    }

    public void deleteSchemaObject(SchemaObject obj) throws NamingException {
        PartitionNexusProxy proxy = InvocationStack.getInstance().peek().getProxy();
        LdapDN dn = this.getDn(obj);
        proxy.delete(new DeleteOperationContext(dn), BYPASS);
    }

    public void delete(NormalizerDescription normalizerDescription) throws NamingException {
        String schemaName = this.getSchema((AbstractSchemaDescription)normalizerDescription);
        PartitionNexusProxy proxy = InvocationStack.getInstance().peek().getProxy();
        LdapDN dn = new LdapDN("m-oid=" + normalizerDescription.getNumericOid() + ",ou=normalizers,cn=" + schemaName + ",ou=schema");
        proxy.delete(new DeleteOperationContext(dn), BYPASS);
    }

    public void delete(SyntaxCheckerDescription syntaxCheckerDescription) throws NamingException {
        String schemaName = this.getSchema((AbstractSchemaDescription)syntaxCheckerDescription);
        PartitionNexusProxy proxy = InvocationStack.getInstance().peek().getProxy();
        LdapDN dn = new LdapDN("m-oid=" + syntaxCheckerDescription.getNumericOid() + ",ou=syntaxCheckers,cn=" + schemaName + ",ou=schema");
        proxy.delete(new DeleteOperationContext(dn), BYPASS);
    }

    public void delete(ComparatorDescription comparatorDescription) throws NamingException {
        String schemaName = this.getSchema((AbstractSchemaDescription)comparatorDescription);
        PartitionNexusProxy proxy = InvocationStack.getInstance().peek().getProxy();
        LdapDN dn = new LdapDN("m-oid=" + comparatorDescription.getNumericOid() + ",ou=comparators,cn=" + schemaName + ",ou=schema");
        proxy.delete(new DeleteOperationContext(dn), BYPASS);
    }

    public void add(ComparatorDescription comparatorDescription) throws NamingException {
        String schemaName = this.getSchema((AbstractSchemaDescription)comparatorDescription);
        PartitionNexusProxy proxy = InvocationStack.getInstance().peek().getProxy();
        LdapDN dn = new LdapDN("m-oid=" + comparatorDescription.getNumericOid() + ",ou=comparators,cn=" + schemaName + ",ou=schema");
        Attributes attrs = this.getAttributes(comparatorDescription);
        proxy.add(new AddOperationContext(dn, attrs), BYPASS);
    }

    private Attributes getAttributes(ComparatorDescription comparatorDescription) {
        AttributesImpl attributes = new AttributesImpl("objectClass", (Object)"top", true);
        attributes.get("objectClass").add("metaTop");
        attributes.get("objectClass").add("metaComparator");
        attributes.put("m-oid", (Object)comparatorDescription.getNumericOid());
        attributes.put("m-fqcn", (Object)comparatorDescription.getFqcn());
        if (comparatorDescription.getBytecode() != null) {
            attributes.put("m-bytecode", (Object)Base64.decode((char[])comparatorDescription.getBytecode().toCharArray()));
        }
        if (comparatorDescription.getDescription() != null) {
            attributes.put("m-description", (Object)comparatorDescription.getDescription());
        }
        return attributes;
    }

    public void add(NormalizerDescription normalizerDescription) throws NamingException {
        String schemaName = this.getSchema((AbstractSchemaDescription)normalizerDescription);
        PartitionNexusProxy proxy = InvocationStack.getInstance().peek().getProxy();
        LdapDN dn = new LdapDN("m-oid=" + normalizerDescription.getNumericOid() + ",ou=normalizers,cn=" + schemaName + ",ou=schema");
        Attributes attrs = this.getAttributes(normalizerDescription);
        proxy.add(new AddOperationContext(dn, attrs), BYPASS);
    }

    private Attributes getAttributes(NormalizerDescription normalizerDescription) {
        AttributesImpl attributes = new AttributesImpl("objectClass", (Object)"top", true);
        attributes.get("objectClass").add("metaTop");
        attributes.get("objectClass").add("metaNormalizer");
        attributes.put("m-oid", (Object)normalizerDescription.getNumericOid());
        attributes.put("m-fqcn", (Object)normalizerDescription.getFqcn());
        if (normalizerDescription.getBytecode() != null) {
            attributes.put("m-bytecode", (Object)Base64.decode((char[])normalizerDescription.getBytecode().toCharArray()));
        }
        if (normalizerDescription.getDescription() != null) {
            attributes.put("m-description", (Object)normalizerDescription.getDescription());
        }
        return attributes;
    }

    public void add(SyntaxCheckerDescription syntaxCheckerDescription) throws NamingException {
        String schemaName = this.getSchema((AbstractSchemaDescription)syntaxCheckerDescription);
        PartitionNexusProxy proxy = InvocationStack.getInstance().peek().getProxy();
        LdapDN dn = new LdapDN("m-oid=" + syntaxCheckerDescription.getNumericOid() + ",ou=syntaxCheckers,cn=" + schemaName + ",ou=schema");
        Attributes attrs = this.getAttributes(syntaxCheckerDescription);
        proxy.add(new AddOperationContext(dn, attrs), BYPASS);
    }

    private String getSchema(AbstractSchemaDescription desc) {
        if (desc.getExtensions().containsKey("X-SCHEMA")) {
            return (String)((List)desc.getExtensions().get("X-SCHEMA")).get(0);
        }
        return "other";
    }

    private Attributes getAttributes(SyntaxCheckerDescription syntaxCheckerDescription) {
        AttributesImpl attributes = new AttributesImpl("objectClass", (Object)"top", true);
        attributes.get("objectClass").add("metaTop");
        attributes.get("objectClass").add("metaSyntaxChecker");
        attributes.put("m-oid", (Object)syntaxCheckerDescription.getNumericOid());
        attributes.put("m-fqcn", (Object)syntaxCheckerDescription.getFqcn());
        if (syntaxCheckerDescription.getBytecode() != null) {
            attributes.put("m-bytecode", (Object)Base64.decode((char[])syntaxCheckerDescription.getBytecode().toCharArray()));
        }
        if (syntaxCheckerDescription.getDescription() != null) {
            attributes.put("m-description", (Object)syntaxCheckerDescription.getDescription());
        }
        return attributes;
    }

    static {
        HashSet<String> bypass = new HashSet<String>();
        bypass.add("authenticationService");
        bypass.add("referralService");
        bypass.add("authorizationService");
        bypass.add("defaultAuthorizationService");
        bypass.add("exceptionService");
        bypass.add("schemaService");
        BYPASS = Collections.unmodifiableCollection(bypass);
    }
}

