/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.oauth2;

import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.oauth2.clients.ClientRegistry;
import org.nuxeo.ecm.platform.oauth2.request.AuthorizationRequest;
import org.nuxeo.ecm.platform.oauth2.request.TokenRequest;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.platform.oauth2.tokens.OAuth2TokenStore;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoAuthenticationFilter;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoSecuredRequestWrapper;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthPreFilter;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoOAuth2Filter
implements NuxeoAuthPreFilter {
    private static final Log log = LogFactory.getLog(NuxeoOAuth2Filter.class);
    protected static final String TOKEN_SERVICE = "org.nuxeo.server.token.store";
    protected static final String OAUTH2_SEGMENT = "/oauth2/";
    protected static final String ENDPOINT_AUTH = "authorization";
    protected static final String ENDPOINT_TOKEN = "token";
    public static String USERNAME_KEY = "nuxeo_user";
    public static String AUTHORIZATION_KEY = "authorization_key";
    public static String CLIENTNAME_KEY = "client_name";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isValid(request)) {
            chain.doFilter(request, response);
            return;
        }
        boolean startedTx = false;
        if (!TransactionHelper.isTransactionActive()) {
            startedTx = TransactionHelper.startTransaction();
        }
        boolean done = false;
        try {
            this.process(request, response, chain);
            done = true;
        }
        catch (ClientException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (startedTx) {
                if (!done) {
                    TransactionHelper.setTransactionRollbackOnly();
                }
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    protected boolean isValid(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return false;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        return this.isAuthorizedRequest(httpRequest) || httpRequest.getRequestURI().contains(OAUTH2_SEGMENT);
    }

    protected void process(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException, ClientException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        if (uri.contains(OAUTH2_SEGMENT)) {
            String endpoint;
            switch (endpoint = uri.split(OAUTH2_SEGMENT)[1]) {
                case "authorization": {
                    this.processAuthorization(httpRequest, httpResponse, chain);
                    break;
                }
                case "token": {
                    this.processToken(httpRequest, httpResponse, chain);
                }
            }
        } else if (this.isAuthorizedRequest(httpRequest)) {
            this.processAuthentication(httpRequest, httpResponse, chain);
        }
        if (!response.isCommitted()) {
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ClientException, IOException, ServletException {
        String key = URLDecoder.decode(request.getHeader("Authorization").substring(7), "UTF-8").trim();
        NuxeoOAuth2Token token = this.getTokenStore().getToken(key);
        if (token == null) {
            return;
        }
        if (token.isExpired() || !this.getClientRegistry().hasClient(token.getClientId())) {
            response.setStatus(401);
            return;
        }
        LoginContext loginContext = this.buildLoginContext(token);
        if (loginContext != null) {
            Principal principal = (Principal)loginContext.getSubject().getPrincipals().toArray()[0];
            try {
                chain.doFilter((ServletRequest)new NuxeoSecuredRequestWrapper(request, principal), (ServletResponse)response);
            }
            finally {
                try {
                    loginContext.logout();
                }
                catch (LoginException e) {
                    log.warn((Object)"Error when logging out", (Throwable)e);
                }
            }
        }
    }

    protected LoginContext buildLoginContext(NuxeoOAuth2Token token) throws ClientException {
        try {
            return NuxeoAuthenticationFilter.loginAs((String)token.getNuxeoLogin());
        }
        catch (LoginException e) {
            log.warn((Object)"Error while authenticate user");
            return null;
        }
    }

    protected boolean isAuthorizedRequest(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        return authorization != null && authorization.startsWith("Bearer");
    }

    protected void processAuthorization(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ClientException {
        AuthorizationRequest authRequest = AuthorizationRequest.from(request);
        String error = authRequest.checkError();
        if (StringUtils.isNotBlank((String)error)) {
            this.handleError(error, request, response);
            return;
        }
        if (request.getMethod().equals("GET")) {
            request.getSession().setAttribute(AUTHORIZATION_KEY, (Object)authRequest.getAuthorizationKey());
            request.getSession().setAttribute("state", (Object)authRequest.getState());
            request.getSession().setAttribute(CLIENTNAME_KEY, (Object)this.getClientRegistry().getClient(authRequest.getClientId()).getName());
            String base = VirtualHostHelper.getBaseURL((ServletRequest)request);
            this.sendRedirect(response, base + "oauth2Grant.jsp", null);
            return;
        }
        String authKeyForm = request.getParameter(AUTHORIZATION_KEY);
        if (!authRequest.getAuthorizationKey().equals(authKeyForm)) {
            this.handleError(ERRORS.access_denied, request, response);
            return;
        }
        authRequest.setUsername((String)request.getSession().getAttribute(USERNAME_KEY));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", authRequest.getAuthorizationCode());
        if (StringUtils.isNotBlank((String)authRequest.getState())) {
            params.put("state", authRequest.getState());
        }
        request.getSession().invalidate();
        this.sendRedirect(response, authRequest.getRedirectUri(), params);
    }

    ClientRegistry getClientRegistry() {
        return (ClientRegistry)Framework.getLocalService(ClientRegistry.class);
    }

    protected void processToken(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ClientException {
        TokenRequest tokRequest = new TokenRequest(request);
        if ("authorization_code".equals(tokRequest.getGrantType())) {
            AuthorizationRequest authRequest = AuthorizationRequest.fromCode(tokRequest.getCode());
            ERRORS error = null;
            if (authRequest == null) {
                error = ERRORS.access_denied;
            } else if (!authRequest.getClientId().equals(tokRequest.getClientId())) {
                error = ERRORS.access_denied;
            } else if (!this.getClientRegistry().isValidClient(tokRequest.getClientId(), tokRequest.getClientSecret())) {
                error = ERRORS.unauthorized_client;
            } else {
                boolean sameRedirectUri = authRequest.getRedirectUri().equals(tokRequest.getRedirectUri());
                if (!StringUtils.isBlank((String)authRequest.getRedirectUri()) && !sameRedirectUri) {
                    error = ERRORS.invalid_request;
                }
            }
            if (error != null) {
                this.handleError(error, request, response);
                return;
            }
            NuxeoOAuth2Token token = new NuxeoOAuth2Token(3600000L, authRequest.getClientId());
            this.getTokenStore().store(authRequest.getUsername(), token);
            this.handleTokenResponse(token, response);
        } else if ("refresh_token".equals(tokRequest.getGrantType())) {
            ERRORS error = null;
            if (StringUtils.isBlank((String)tokRequest.getClientId())) {
                error = ERRORS.access_denied;
            } else if (!this.getClientRegistry().isValidClient(tokRequest.getClientId(), tokRequest.getClientSecret())) {
                error = ERRORS.access_denied;
            }
            if (error != null) {
                this.handleError(error, request, response);
                return;
            }
            NuxeoOAuth2Token refreshed = this.getTokenStore().refresh(tokRequest.getRefreshToken(), tokRequest.getClientId());
            if (refreshed == null) {
                this.handleJsonError(ERRORS.invalid_request, request, response);
            } else {
                this.handleTokenResponse(refreshed, response);
            }
        } else {
            this.handleJsonError(ERRORS.invalid_grant, request, response);
        }
    }

    protected void handleTokenResponse(NuxeoOAuth2Token token, HttpServletResponse response) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        response.setHeader("Content-Type", "application/json");
        response.setStatus(200);
        mapper.writeValue((Writer)response.getWriter(), token.toJsonObject());
    }

    protected void handleError(ERRORS error, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handleError(error.toString(), request, response);
    }

    protected void handleError(String error, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("error", error);
        String state = request.getParameter("state");
        if (StringUtils.isNotBlank((String)state)) {
            params.put("state", state);
        }
        String redirectUri = request.getParameter("redirect_uri");
        this.sendRedirect(response, redirectUri, params);
    }

    protected void handleJsonError(ERRORS error, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        response.setHeader("Content-Type", "application/json");
        response.setStatus(400);
        HashMap<String, String> object = new HashMap<String, String>();
        object.put("error", error.toString());
        mapper.writeValue((Writer)response.getWriter(), object);
    }

    protected void sendRedirect(HttpServletResponse response, String uri, Map<String, String> params) throws IOException {
        if (uri == null) {
            uri = "http://dummyurl";
        }
        StringBuilder sb = new StringBuilder(uri);
        if (params != null) {
            if (!uri.contains("?")) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            for (String key : params.keySet()) {
                sb.append(key).append("=").append(params.get(key)).append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        response.sendRedirect(sb.toString());
    }

    protected OAuth2TokenStore getTokenStore() {
        return new OAuth2TokenStore(TOKEN_SERVICE);
    }

    public static enum ERRORS {
        invalid_request,
        invalid_grant,
        unauthorized_client,
        access_denied,
        unsupported_response_type,
        invalid_scope,
        server_error,
        temporarily_unavailable;

    }
}

