/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcher;

public class ResourceWatcherService
extends AbstractLifecycleComponent<ResourceWatcherService> {
    private final List<ResourceWatcher> watchers = new CopyOnWriteArrayList<ResourceWatcher>();
    private volatile ScheduledFuture scheduledFuture;
    private final boolean enabled = this.componentSettings.getAsBoolean("enabled", (Boolean)true);
    private final TimeValue interval = this.componentSettings.getAsTime("interval", TimeValue.timeValueSeconds(60L));
    private final ThreadPool threadPool;

    @Inject
    public ResourceWatcherService(Settings settings, ThreadPool threadPool) {
        super(settings);
        this.threadPool = threadPool;
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        if (!this.enabled) {
            return;
        }
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(new ResourceMonitor(), this.interval);
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        if (!this.enabled) {
            return;
        }
        this.scheduledFuture.cancel(true);
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    public void add(ResourceWatcher watcher) {
        watcher.init();
        this.watchers.add(watcher);
    }

    public void remove(ResourceWatcher watcher) {
        this.watchers.remove(watcher);
    }

    private class ResourceMonitor
    implements Runnable {
        private ResourceMonitor() {
        }

        @Override
        public void run() {
            for (ResourceWatcher watcher : ResourceWatcherService.this.watchers) {
                watcher.checkAndNotify();
            }
        }
    }
}

