/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.fragments.configuration;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.local.configuration.WebConfsConfiguration;
import fr.toutatice.ecm.platform.core.local.configuration.WebConfsConfigurationAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;

@Name(value="config")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ConfigurationBeanHelper
implements Serializable {
    private static final long serialVersionUID = 3182188147180903548L;
    private static final String WCONF_OPTIONS = "wconf:options";
    private static final Log log = LogFactory.getLog(ConfigurationBeanHelper.class);
    private static final String WEB_CONFS_QUERY = "select * from WebConfiguration where ecm:ancestorId = '%s' and wconf:type = '%s' AND wconf:enabled=1 AND ecm:mixinType != 'HiddenInNavigation'  AND ecm:currentLifeCycleState <> 'deleted' ORDER BY ecm:pos";
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected Map<String, String> messages;

    public static ConfigurationBeanHelper getBean() {
        return (ConfigurationBeanHelper)SeamComponentCallHelper.getSeamComponentByName((String)"config");
    }

    public DocumentModelList getConfigs(String confType) {
        CoreSession session = this.navigationContext.getOrCreateDocumentManager();
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        DocumentModel domain = ToutaticeDocumentHelper.getDomain((CoreSession)session, (DocumentModel)doc, (boolean)true);
        return this.getConfigs(confType, session, domain);
    }

    public DocumentModelList getConfigs(String confType, CoreSession session, DocumentModel domain) {
        List<DocumentModel> configs = null;
        if (domain != null) {
            UnrestrictedGetAllWebConfs allConfsGetter = new UnrestrictedGetAllWebConfs(session, domain, confType);
            allConfsGetter.runUnrestricted();
            configs = allConfsGetter.getWebConfs();
        }
        DocumentModelListImpl configurations = null;
        if (configs != null) {
            configurations = new DocumentModelListImpl(configs);
        }
        return configurations;
    }

    protected static List<DocumentModel> mergeGlobalNLocalConfs(List<DocumentModel> globalConfs, DocumentModelList localConfs, String confType) {
        ArrayList<DocumentModel> mergedConfs = new ArrayList(0);
        mergedConfs = ConfigurationBeanHelper.getSelectedConfsByType(globalConfs, confType);
        for (DocumentModel localConf : localConfs) {
            String localCode = (String)((Object)localConf.getPropertyValue("wconf:code"));
            boolean hasCode = false;
            Iterator it = mergedConfs.iterator();
            while (it.hasNext() && !hasCode) {
                DocumentModel globalConf = (DocumentModel)it.next();
                String globalCode = (String)((Object)globalConf.getPropertyValue("wconf:code"));
                if (!localCode.equals(globalCode)) continue;
                it.remove();
                mergedConfs.add(localConf);
                hasCode = true;
            }
        }
        return mergedConfs;
    }

    protected static List<DocumentModel> getSelectedConfsByType(List<DocumentModel> selectedConfs, String confType) {
        ArrayList<DocumentModel> confsByTypes = new ArrayList<DocumentModel>(0);
        for (DocumentModel selectedConf : selectedConfs) {
            String type = (String)((Object)selectedConf.getPropertyValue("wconf:type"));
            if (!confType.equals(type)) continue;
            confsByTypes.add(selectedConf);
        }
        return confsByTypes;
    }

    public DocumentModelList getPageTemplates() {
        return this.getConfigs("pagetemplate");
    }

    public DocumentModelList getPageThemes() {
        return this.getConfigs("pagetheme");
    }

    public DocumentModelList getFragmentTypes() {
        return this.getConfigs("fragmenttype");
    }

    public DocumentModelList getWindowStyles() {
        return this.getConfigs("windowstyle");
    }

    public DocumentModelList getListTemplates() {
        return this.getConfigs("listtemplate");
    }

    public DocumentModelList getZoomTemplates() {
        return this.getConfigs("zoomtemplate");
    }

    public DocumentModelList getLinksTemplates() {
        return this.getConfigs("linkstemplate");
    }

    public DocumentModelList getSliderTemplates() {
        return this.getConfigs("slidertemplate");
    }

    public DocumentModelList getRegionLayouts() {
        return this.getConfigs("regionlayout");
    }

    public List<Map<String, String>> getFragmentOptionsByCode(DocumentModel doc, String code2) {
        try {
            DocumentModel config;
            Map properties;
            DocumentModelList configurations;
            CoreSession session = this.navigationContext.getOrCreateDocumentManager();
            String type = doc.getType();
            String confPath = null;
            DocumentModel child = null;
            while (!type.equals("Domain") && doc != child) {
                child = doc;
                if ((doc = session.getDocument(doc.getParentRef())) == null || !(type = doc.getType()).equals("Domain")) continue;
                confPath = doc.getPath().toString();
            }
            String query = "select * from Document where ecm:primaryType = 'WebConfiguration'   AND wconf:type =  'fragmenttype' AND wconf:enabled=1   AND ecm:mixinType != 'HiddenInNavigation'  AND ecm:currentLifeCycleState <> 'deleted'   AND wconf:code2 = '" + code2 + "'";
            if (confPath != null) {
                query = query.concat(" AND ecm:path STARTSWITH '" + confPath + "' ");
            }
            if ((configurations = session.query(query)).get(0) != null && (properties = (config = (DocumentModel)configurations.get(0)).getProperties("webconfiguration")).containsKey(WCONF_OPTIONS) && properties.get(WCONF_OPTIONS) != null) {
                return (List)properties.get(WCONF_OPTIONS);
            }
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean getWebsiteParam(String paramName) {
        return BooleanUtils.toBoolean((String)this.getPropertyValue(paramName));
    }

    private String getPropertyValue(String paramName) {
        DocumentModelList configs = this.getConfigs("websiteConfig");
        if (configs.size() > 0) {
            DocumentModel websiteconfig = (DocumentModel)configs.get(0);
            Map properties = websiteconfig.getProperties("webconfiguration");
            List options = (List)properties.get(WCONF_OPTIONS);
            for (Map option : options) {
                if (!((String)option.get("propertyName")).equals(paramName)) continue;
                return (String)option.get("propertyDefaultValue");
            }
        }
        return null;
    }

    public String getWebsiteParamString(String paramName, String defaultValue) {
        String propertyValue = this.getPropertyValue(paramName);
        return propertyValue == null ? defaultValue : propertyValue;
    }

    public static class UnrestrictedGetAllWebConfs
    extends UnrestrictedSessionRunner {
        private DocumentModel domain;
        private String confType;
        private List<DocumentModel> webConfs;

        protected UnrestrictedGetAllWebConfs(CoreSession session, DocumentModel domain, String confType) {
            super(session);
            this.domain = domain;
            this.confType = confType;
        }

        public List<DocumentModel> getWebConfs() {
            return this.webConfs;
        }

        public void run() throws ClientException {
            String localQuery = String.format(ConfigurationBeanHelper.WEB_CONFS_QUERY, this.domain.getId(), this.confType);
            DocumentModelList localConfs = this.session.query(localQuery);
            if (this.domain.hasFacet("WebConfigurationsLocalConfiguration")) {
                WebConfsConfiguration webConfsConfiguration = (WebConfsConfiguration)this.domain.getAdapter(WebConfsConfiguration.class);
                if (webConfsConfiguration != null) {
                    List selectedConfs = webConfsConfiguration.getSelectedConfs(this.domain);
                    this.webConfs = selectedConfs != null ? new ArrayList<DocumentModel>(ConfigurationBeanHelper.mergeGlobalNLocalConfs(selectedConfs, localConfs, this.confType)) : new ArrayList<DocumentModel>(ConfigurationBeanHelper.getSelectedConfsByType((List<DocumentModel>)localConfs, this.confType));
                }
            } else {
                WebConfsConfigurationAdapter.UnrestrictedGetGlobalWebConfs globalConfsGetter = new WebConfsConfigurationAdapter.UnrestrictedGetGlobalWebConfs(this.session);
                globalConfsGetter.runUnrestricted();
                DocumentModelList globalConfs = globalConfsGetter.getWebConfs();
                this.webConfs = globalConfs != null && !globalConfs.isEmpty() ? new ArrayList<DocumentModel>(ConfigurationBeanHelper.mergeGlobalNLocalConfs((List<DocumentModel>)globalConfs, localConfs, this.confType)) : new ArrayList<DocumentModel>(ConfigurationBeanHelper.getSelectedConfsByType((List<DocumentModel>)localConfs, this.confType));
            }
        }
    }
}

