/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.url;

import fr.toutatice.ecm.platform.service.url.ToutaticeDocumentLocation;
import fr.toutatice.ecm.platform.service.url.WebIdRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;

public class WebIdCodec
extends AbstractDocumentViewCodec {
    private static final Log log = LogFactory.getLog(WebIdCodec.class);
    public static final String CONTENT_PARAM = "content";
    public static final String PREFIX = "web/";
    private static final String DEFAULT_REPO = "default";
    public static final String DOC_TYPE = "DOC_TYPE";
    public static final String FILE_PROPERTY_PATH_KEY = "FILE_PROPERTY_PATH";
    public static final String FILENAME_KEY = "FILENAME";

    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        return PREFIX;
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        String[] segments;
        if (url.startsWith(PREFIX) && (segments = (url = url.substring(PREFIX.length())).split("/")).length >= 1) {
            String webid;
            String lastSegment = segments[segments.length - 1];
            String extensionUrl = null;
            String explicitUrl = null;
            int extMarker = StringUtils.indexOf((String)lastSegment, (String)".");
            int paramMarker = StringUtils.indexOf((String)lastSegment, (String)"?");
            if (extMarker > -1) {
                webid = StringUtils.substring((String)lastSegment, (int)0, (int)extMarker);
                extensionUrl = paramMarker > -1 ? StringUtils.substring((String)lastSegment, (int)extMarker, (int)paramMarker) : StringUtils.substring((String)lastSegment, (int)extMarker, (int)lastSegment.length());
            } else {
                webid = paramMarker > -1 ? StringUtils.substring((String)lastSegment, (int)0, (int)paramMarker) : lastSegment;
            }
            if (segments.length >= 3) {
                ArrayList<String> items = new ArrayList<String>();
                for (int index = 1; index < segments.length - 2; ++index) {
                    items.add(segments[index]);
                }
                explicitUrl = StringUtils.join(items, (String)"/");
            }
            HashMap<String, String> params = null;
            if (paramMarker > -1) {
                params = new HashMap<String, String>();
                String paramsStr = StringUtils.substringAfter((String)lastSegment, (String)"?");
                String[] paramsArr = StringUtils.split((String)paramsStr, (String)"&");
                for (int i = 0; i < paramsArr.length; ++i) {
                    String[] pair = paramsArr[i].split("=");
                    if (pair.length != 2) continue;
                    params.put(pair[0], pair[1]);
                }
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (params != null) {
                String content = (String)params.get(CONTENT_PARAM);
                if (content != null) {
                    parameters.put(FILE_PROPERTY_PATH_KEY, content.concat(":content"));
                } else {
                    parameters.put(FILE_PROPERTY_PATH_KEY, "Original:content");
                }
                parameters.put(FILENAME_KEY, webid);
                parameters.putAll(params);
            }
            ToutaticeDocumentLocation docLoc = new ToutaticeDocumentLocation(DEFAULT_REPO, new WebIdRef(explicitUrl, webid, extensionUrl, parameters));
            DocumentViewImpl documentViewImpl = new DocumentViewImpl((DocumentLocation)docLoc, "view_documents", parameters);
            return documentViewImpl;
        }
        return null;
    }

    public String getUrlFromDocumentView(DocumentView docView) {
        ToutaticeDocumentLocation docLoc = (ToutaticeDocumentLocation)docView.getDocumentLocation();
        WebIdRef webIdRef = docLoc.getWebIdRef();
        String webId = (String)webIdRef.reference();
        String explicitUrl = webIdRef.getExplicitUrl();
        if (StringUtils.isNotBlank((String)webId)) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            if (StringUtils.isNotBlank((String)explicitUrl)) {
                items.add(explicitUrl);
            }
            items.add(webId);
            String uri = StringUtils.join(items, (String)"/");
            Map<String, String> locParameters = docLoc.getParameters();
            locParameters.putAll(docView.getParameters());
            return URIUtils.addParametersToURIQuery((String)uri, locParameters);
        }
        return null;
    }
}

