/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.workflows;

import fr.toutatice.ecm.platform.service.workflows.TaskDescriptor;
import fr.toutatice.ecm.platform.service.workflows.ToutaticeTaskService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.core.helpers.TaskActorsHelper;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ToutaticeTaskServiceImpl
extends DefaultComponent
implements ToutaticeTaskService {
    private static final Log log = LogFactory.getLog(ToutaticeTaskServiceImpl.class);
    private static final String TASKS_EXT_POINT = "tasks";
    private Map<String, String> tasksContribs;

    @Override
    public boolean hasContributions() {
        return MapUtils.isNotEmpty(this.tasksContribs);
    }

    @Override
    public Map<String, String> getTaskContributions() {
        return this.tasksContribs;
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.tasksContribs = new HashMap<String, String>(0);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (TASKS_EXT_POINT.equals(extensionPoint)) {
            TaskDescriptor taskDesc = (TaskDescriptor)contribution;
            String taskName = taskDesc.getTaskName();
            String permission = taskDesc.getPermission();
            if (StringUtils.isNotBlank((String)taskName)) {
                this.tasksContribs.put(taskName, permission);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        TaskDescriptor taskDesc;
        String taskName;
        if (TASKS_EXT_POINT.equals(extensionPoint) && StringUtils.isNotBlank((String)(taskName = (taskDesc = (TaskDescriptor)contribution).getTaskName()))) {
            this.tasksContribs.remove(taskName);
        }
    }

    @Override
    public boolean isTaskPending(Task task) throws ClientException {
        boolean isPending = false;
        if (task != null) {
            isPending = task.isOpened();
        }
        return isPending;
    }

    @Override
    public boolean isUserTaskInitiator(CoreSession coreSession, Task task) throws ClientException {
        String taskInitiator;
        boolean isInitiator = false;
        if (task != null && StringUtils.isNotBlank((String)(taskInitiator = task.getInitiator()))) {
            NuxeoPrincipal currentUser = (NuxeoPrincipal)coreSession.getPrincipal();
            isInitiator = taskInitiator.equals(currentUser.getName());
        }
        return isInitiator;
    }

    @Override
    public boolean canUserManageTask(CoreSession coreSession, Task currentTask, DocumentModel currentDocument, String permission) throws ClientException {
        boolean canValidate = false;
        boolean isActor = false;
        if (currentTask != null) {
            NuxeoPrincipal principal;
            List actors = currentTask.getActors();
            if (actors != null && !actors.isEmpty() && (principal = (NuxeoPrincipal)coreSession.getPrincipal()) != null) {
                List taskActors = TaskActorsHelper.getTaskActors((NuxeoPrincipal)principal);
                isActor = CollectionUtils.isSubCollection((Collection)actors, (Collection)taskActors);
            }
            if (isActor) {
                canValidate = this.checkPermission(coreSession, currentDocument, permission);
            }
        }
        return canValidate;
    }

    private Boolean checkPermission(CoreSession coreSession, DocumentModel currentDocument, String permission) throws ClientException {
        if (StringUtils.isBlank((String)permission)) {
            return Boolean.TRUE;
        }
        Boolean can = Boolean.FALSE;
        try {
            can = coreSession.hasPermission(currentDocument.getRef(), permission);
        }
        catch (ClientException e) {
            if (e instanceof DocumentSecurityException) {
                return Boolean.FALSE;
            }
            log.warn((Object)("Failed to fetch permissions for document '" + currentDocument.getPathAsString() + "', error:" + e.getMessage()));
            throw new ClientException(e);
        }
        return can;
    }
}

